/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.solr.trident;

import java.util.List;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.storm.solr.config.SolrConfig;
import org.apache.storm.solr.mapper.SolrMapper;
import org.apache.storm.topology.FailedException;
import org.apache.storm.trident.state.State;
import org.apache.storm.trident.tuple.TridentTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrState
implements State {
    private static final Logger logger = LoggerFactory.getLogger(SolrState.class);
    private final SolrConfig solrConfig;
    private final SolrMapper solrMapper;
    private SolrClient solrClient;

    public SolrState(SolrConfig solrConfig, SolrMapper solrMapper) {
        this.solrConfig = solrConfig;
        this.solrMapper = solrMapper;
    }

    protected void prepare() {
        this.solrClient = new CloudSolrClient(this.solrConfig.getZkHostString());
    }

    public void beginCommit(Long aLong) {
    }

    public void commit(Long aLong) {
    }

    public void updateState(List<TridentTuple> tuples) {
        try {
            SolrRequest solrRequest = this.solrMapper.toSolrRequest(tuples);
            this.solrClient.request(solrRequest, this.solrMapper.getCollection());
            this.solrClient.commit(this.solrMapper.getCollection());
        }
        catch (Exception e) {
            String msg = String.format("%s", tuples);
            logger.warn(msg);
            throw new FailedException(msg, (Throwable)e);
        }
    }
}

