/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.solr.schema.builder;

import com.google.gson.Gson;
import java.io.IOException;
import java.net.URL;
import java.util.Scanner;
import org.apache.storm.solr.schema.Schema;
import org.apache.storm.solr.schema.builder.SchemaBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestJsonSchemaBuilder
implements SchemaBuilder {
    private static final Logger logger = LoggerFactory.getLogger(RestJsonSchemaBuilder.class);
    private Schema schema;

    public RestJsonSchemaBuilder(String solrHost, String solrPort, String collection) throws IOException {
        this(new URL("http://" + solrHost + ":" + solrPort + "/solr/" + collection + "/schema/"));
    }

    public RestJsonSchemaBuilder(String url) throws IOException {
        this(new URL(url));
    }

    public RestJsonSchemaBuilder(URL url) throws IOException {
        this.downloadSchema(url);
    }

    private void downloadSchema(URL url) throws IOException {
        logger.debug("Downloading Solr schema info from: " + url);
        Scanner scanner = new Scanner(url.openStream());
        String result = scanner.useDelimiter("\\Z").next();
        logger.debug("JSON Schema: " + result);
        Gson gson = new Gson();
        Schema.SchemaWrapper schemaWrapper = (Schema.SchemaWrapper)gson.fromJson(result, Schema.SchemaWrapper.class);
        this.schema = schemaWrapper.getSchema();
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }
}

