/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.solr.schema;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.storm.solr.schema.Field;
import org.apache.storm.solr.schema.FieldType;
import org.apache.storm.solr.schema.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrFieldTypeFinder
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(SolrFieldTypeFinder.class);
    private Schema schema;
    private Map<String, FieldTypeWrapper> fieldToWrapper;

    public SolrFieldTypeFinder(Schema schema) {
        if (schema == null) {
            throw new IllegalArgumentException("Schema object is null");
        }
        this.schema = schema;
        this.fieldToWrapper = new HashMap<String, FieldTypeWrapper>();
        this.buildMap();
    }

    private void buildMap() {
        List<FieldType> fieldTypes = this.schema.getFieldTypes();
        this.buildMapForFields(fieldTypes, this.schema.getFields());
        this.buildMapForFields(fieldTypes, this.schema.getDynamicFields());
        if (log.isDebugEnabled()) {
            log.debug("Completed building FieldType Map: " + this.fieldToWrapper);
        }
    }

    private void buildMapForFields(List<FieldType> fieldTypes, List<Field> fields) {
        for (Field field : fields) {
            String type = field.getType();
            int idx = this.indexOf(fieldTypes, type);
            if (idx == -1) continue;
            this.fieldToWrapper.put(field.getName(), new FieldTypeWrapper(field, fieldTypes.get(idx)));
        }
    }

    private int indexOf(List<FieldType> fieldTypes, String type) {
        int i = 0;
        for (FieldType fieldType : fieldTypes) {
            if (fieldType.getName().equals(type)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public FieldTypeWrapper getFieldTypeWrapper(String fieldName) {
        FieldTypeWrapper typeWrapper = this.fieldToWrapper.get(fieldName);
        if (typeWrapper == null) {
            for (String pattern : this.fieldToWrapper.keySet()) {
                if (!this.matchesDynamicField(fieldName, pattern)) continue;
                typeWrapper = this.fieldToWrapper.get(pattern);
            }
        }
        log.debug("Solr Field Name = {}, Solr Type = {}", (Object)fieldName, (Object)typeWrapper);
        return typeWrapper;
    }

    public Set<String> getAllSolrFieldTypes() {
        Collection<FieldTypeWrapper> typeWrappers = this.fieldToWrapper.values();
        TreeSet<String> fieldTypeClasses = new TreeSet<String>();
        for (FieldTypeWrapper typeWrapper : typeWrappers) {
            fieldTypeClasses.add(typeWrapper.getType().getClazz());
        }
        log.debug("Field type classes present in schema: {}", fieldTypeClasses);
        return fieldTypeClasses;
    }

    public boolean matchesField(String fieldName) {
        return this.fieldToWrapper.containsKey(fieldName);
    }

    public boolean matchesDynamicField(String fieldName) {
        for (String pattern : this.fieldToWrapper.keySet()) {
            if (!this.matchesDynamicField(fieldName, pattern)) continue;
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("Field [{}] did NOT match any dynamic field present in {}", (Object)fieldName, this.fieldToWrapper.keySet());
        }
        return false;
    }

    public boolean matchesDynamicField(String fieldName, String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("pattern and fieldName arguments cannot be null");
        }
        if (pattern.startsWith("*")) {
            if (fieldName.endsWith(pattern.substring(1))) {
                log.debug("Field [{}] MATCHES dynamic field {}", (Object)fieldName, (Object)pattern);
                return true;
            }
        } else if (pattern.endsWith("*") && fieldName.startsWith(pattern.substring(0, pattern.length() - 1))) {
            log.debug("Field [{}] MATCHES dynamic field {}", (Object)fieldName, (Object)pattern);
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("Field [{}] did NOT match any dynamic field present in {}", (Object)fieldName, this.fieldToWrapper.keySet());
        }
        return false;
    }

    public static class FieldTypeWrapper
    implements Serializable {
        Field field;
        FieldType type;

        public FieldTypeWrapper(Field field, FieldType type) {
            this.field = field;
            this.type = type;
        }

        public Field getField() {
            return this.field;
        }

        public FieldType getType() {
            return this.type;
        }

        public String toString() {
            return "FieldTypeWrapper{field=" + this.field + ", type=" + this.type + '}';
        }
    }
}

