/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.solr.mapper;

import com.google.gson.Gson;
import java.util.List;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.request.ContentStreamUpdateRequest;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.storm.solr.mapper.SolrMapper;
import org.apache.storm.solr.mapper.SolrMapperException;
import org.apache.storm.tuple.ITuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrJsonMapper
implements SolrMapper {
    private static final Logger logger = LoggerFactory.getLogger(SolrJsonMapper.class);
    private static final String CONTENT_TYPE = "application/json";
    private final String jsonUpdateUrl;
    private final String jsonTupleField;
    private final String collection;

    private SolrJsonMapper(Builder builder) {
        this.jsonTupleField = builder.jsonTupleField;
        this.collection = builder.collection;
        this.jsonUpdateUrl = builder.jsonUpdateUrl;
    }

    @Override
    public String getCollection() {
        return this.collection;
    }

    @Override
    public SolrRequest toSolrRequest(List<? extends ITuple> tuples) throws SolrMapperException {
        String jsonList = this.getJsonFromTuples(tuples);
        return this.createtSolrRequest(jsonList);
    }

    @Override
    public SolrRequest toSolrRequest(ITuple tuple) throws SolrMapperException {
        String json = this.getJsonFromTuple(tuple);
        return this.createtSolrRequest(json);
    }

    private SolrRequest createtSolrRequest(String json) {
        ContentStreamUpdateRequest request = new ContentStreamUpdateRequest(this.jsonUpdateUrl);
        ContentStreamBase.StringStream cs = new ContentStreamBase.StringStream(json, CONTENT_TYPE);
        request.addContentStream((ContentStream)cs);
        if (logger.isDebugEnabled()) {
            logger.debug("Request generated with JSON: " + json);
        }
        return request;
    }

    private String getJsonFromTuples(List<? extends ITuple> tuples) throws SolrMapperException {
        StringBuilder jsonListBuilder = new StringBuilder("[");
        for (ITuple iTuple : tuples) {
            String json = this.getJsonFromTuple(iTuple);
            jsonListBuilder.append(json).append(",");
        }
        jsonListBuilder.setCharAt(jsonListBuilder.length() - 1, ']');
        return jsonListBuilder.toString();
    }

    private String getJsonFromTuple(ITuple tuple) throws SolrMapperException {
        String json = "";
        if (!tuple.contains(this.jsonTupleField)) {
            throw new SolrMapperException("Tuple does not contain JSON object");
        }
        json = this.doGetJson(tuple.getValueByField(this.jsonTupleField));
        return json;
    }

    private String doGetJson(Object value) {
        String json = "";
        if (value instanceof String) {
            json = (String)value;
        } else {
            Gson gson = new Gson();
            json = gson.toJson(value);
        }
        return json;
    }

    public static class Builder {
        private String jsonUpdateUrl = "/update/json/docs";
        private final String jsonTupleField;
        private final String collection;

        public Builder(String collection, String jsonTupleField) {
            this.collection = collection;
            this.jsonTupleField = jsonTupleField;
        }

        public Builder(SolrClient solrClient, String jsonTupleField) {
            String defaultCollection = null;
            if (solrClient instanceof CloudSolrClient) {
                defaultCollection = ((CloudSolrClient)solrClient).getDefaultCollection();
            }
            this.collection = defaultCollection;
            this.jsonTupleField = jsonTupleField;
        }

        public Builder setJsonUpdateUrl(String jsonUpdateUrl) {
            this.jsonUpdateUrl = jsonUpdateUrl;
            return this;
        }

        public SolrJsonMapper build() {
            return new SolrJsonMapper(this);
        }
    }
}

