/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.solr.mapper;

import java.util.LinkedList;
import java.util.List;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.common.SolrInputDocument;
import org.apache.storm.solr.mapper.SolrMapper;
import org.apache.storm.solr.mapper.SolrMapperException;
import org.apache.storm.solr.schema.FieldType;
import org.apache.storm.solr.schema.Schema;
import org.apache.storm.solr.schema.SolrFieldTypeFinder;
import org.apache.storm.solr.schema.builder.SchemaBuilder;
import org.apache.storm.tuple.ITuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrFieldsMapper
implements SolrMapper {
    private static final Logger log = LoggerFactory.getLogger(SolrFieldsMapper.class);
    private String collection;
    private SolrFieldTypeFinder typeFinder;
    private String multiValueFieldToken;

    private SolrFieldsMapper(Builder builder) {
        this.collection = builder.collection;
        this.typeFinder = builder.typeFinder;
        this.multiValueFieldToken = builder.multiValueFieldToken;
        log.debug("Created {} with the following configuration: [{}] " + this.getClass().getSimpleName(), (Object)this.toString());
    }

    @Override
    public String getCollection() {
        return this.collection;
    }

    @Override
    public SolrRequest toSolrRequest(List<? extends ITuple> tuples) throws SolrMapperException {
        LinkedList<SolrInputDocument> docs = new LinkedList<SolrInputDocument>();
        for (ITuple iTuple : tuples) {
            docs.add(this.buildDocument(iTuple));
        }
        UpdateRequest request = new UpdateRequest();
        request.add(docs);
        log.debug("Created SolrRequest with content: {}", docs);
        return request;
    }

    @Override
    public SolrRequest toSolrRequest(ITuple tuple) throws SolrMapperException {
        SolrInputDocument doc = this.buildDocument(tuple);
        UpdateRequest request = new UpdateRequest();
        request.add(doc);
        log.debug("Created SolrRequest with content: {}", (Object)doc);
        return request;
    }

    private SolrInputDocument buildDocument(ITuple tuple) {
        SolrInputDocument doc = new SolrInputDocument();
        for (String tupleField : tuple.getFields()) {
            SolrFieldTypeFinder.FieldTypeWrapper fieldTypeWrapper = this.typeFinder.getFieldTypeWrapper(tupleField);
            if (fieldTypeWrapper != null) {
                FieldType fieldType = fieldTypeWrapper.getType();
                if (fieldType.isMultiValued()) {
                    this.addMultivalueFieldToDoc(doc, tupleField, tuple);
                    continue;
                }
                this.addFieldToDoc(doc, tupleField, tuple);
                continue;
            }
            log.debug("Field [{}] does NOT match static or dynamic field declared in schema. Not added to document", (Object)tupleField);
        }
        return doc;
    }

    private void addFieldToDoc(SolrInputDocument doc, String tupleField, ITuple tuple) {
        Object val = this.getValue(tupleField, tuple);
        log.debug("Adding to document (field, val) = ({}, {})", (Object)tupleField, val);
        doc.addField(tupleField, val);
    }

    private void addMultivalueFieldToDoc(SolrInputDocument doc, String tupleField, ITuple tuple) {
        String[] values;
        for (String value : values = this.getValues(tupleField, tuple)) {
            log.debug("Adding {} to multivalue field document {}", (Object)value, (Object)tupleField);
            doc.addField(tupleField, (Object)value);
        }
    }

    private Object getValue(String field, ITuple tuple) {
        return tuple.getValueByField(field);
    }

    private String[] getValues(String field, ITuple tuple) {
        String multiValueField = tuple.getStringByField(field);
        String[] values = multiValueField.split(this.multiValueFieldToken);
        return values;
    }

    public String toString() {
        return "SolrFieldsMapper{collection='" + this.collection + '\'' + ", typeFinder=" + this.typeFinder + ", multiValueFieldToken='" + this.multiValueFieldToken + '\'' + '}';
    }

    public static class Builder {
        private String collection;
        private SolrFieldTypeFinder typeFinder;
        private String multiValueFieldToken = "|";

        public Builder(SchemaBuilder schemaBuilder, String collection) {
            this.setTypeFinder(schemaBuilder);
            this.collection = collection;
        }

        public Builder(SchemaBuilder schemaBuilder, SolrClient solrClient) {
            this.setTypeFinder(schemaBuilder);
        }

        private void setTypeFinder(SchemaBuilder schemaBuilder) {
            Schema schema = schemaBuilder.getSchema();
            this.typeFinder = new SolrFieldTypeFinder(schema);
        }

        private void setDefaultCollection(SolrClient solrClient) {
            String defaultCollection = null;
            if (solrClient instanceof CloudSolrClient) {
                defaultCollection = ((CloudSolrClient)solrClient).getDefaultCollection();
            }
            this.collection = defaultCollection;
        }

        public Builder setMultiValueFieldToken(String multiValueFieldToken) {
            this.multiValueFieldToken = multiValueFieldToken;
            return this;
        }

        public SolrFieldsMapper build() {
            return new SolrFieldsMapper(this);
        }
    }
}

