/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.solr.config;

import org.apache.storm.solr.config.SolrCommitStrategy;

public class CountBasedCommit
implements SolrCommitStrategy {
    private int threshold;
    private int count;

    public CountBasedCommit(int threshold) {
        if (threshold < 1) {
            throw new IllegalArgumentException("Threshold must be a positive integer: " + threshold);
        }
        this.threshold = threshold;
    }

    @Override
    public boolean commit() {
        return this.count != 0 && this.count % this.threshold == 0;
    }

    @Override
    public void update() {
        ++this.count;
    }

    public int getCount() {
        return this.count;
    }

    public int getThreshold() {
        return this.threshold;
    }
}

