/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.solr.bolt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.storm.solr.config.CountBasedCommit;
import org.apache.storm.solr.config.SolrCommitStrategy;
import org.apache.storm.solr.config.SolrConfig;
import org.apache.storm.solr.mapper.SolrMapper;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.base.BaseTickTupleAwareRichBolt;
import org.apache.storm.tuple.ITuple;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.utils.TupleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrUpdateBolt
extends BaseTickTupleAwareRichBolt {
    private static final Logger LOG = LoggerFactory.getLogger(SolrUpdateBolt.class);
    private static final int DEFAULT_TICK_TUPLE_INTERVAL_SECS = 15;
    private final SolrConfig solrConfig;
    private final SolrMapper solrMapper;
    private final SolrCommitStrategy commitStgy;
    private SolrClient solrClient;
    private OutputCollector collector;
    private List<Tuple> toCommitTuples;
    private int tickTupleInterval = 15;

    public SolrUpdateBolt(SolrConfig solrConfig, SolrMapper solrMapper) {
        this(solrConfig, solrMapper, null);
    }

    public SolrUpdateBolt(SolrConfig solrConfig, SolrMapper solrMapper, SolrCommitStrategy commitStgy) {
        this.solrConfig = solrConfig;
        this.solrMapper = solrMapper;
        this.commitStgy = commitStgy;
        LOG.debug("Created {} with the following configuration: [SolrConfig = {}], [SolrMapper = {}], [CommitStgy = {}]", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), solrConfig, solrMapper, commitStgy});
    }

    public void prepare(Map stormConf, TopologyContext context, OutputCollector collector) {
        this.collector = collector;
        this.solrClient = new CloudSolrClient(this.solrConfig.getZkHostString());
        this.toCommitTuples = new ArrayList<Tuple>(this.capacity());
    }

    private int capacity() {
        int defArrListCpcty = 10;
        return this.commitStgy instanceof CountBasedCommit ? ((CountBasedCommit)this.commitStgy).getThreshold() : 10;
    }

    protected void process(Tuple tuple) {
        try {
            SolrRequest request = this.solrMapper.toSolrRequest((ITuple)tuple);
            this.solrClient.request(request, this.solrMapper.getCollection());
            this.ack(tuple);
        }
        catch (Exception e) {
            this.fail(tuple, e);
        }
    }

    private void ack(Tuple tuple) throws SolrServerException, IOException {
        if (this.commitStgy == null) {
            this.collector.ack(tuple);
        } else {
            boolean isTickTuple = TupleUtils.isTick((Tuple)tuple);
            if (!isTickTuple) {
                this.toCommitTuples.add(tuple);
                this.commitStgy.update();
            }
            if (isTickTuple || this.commitStgy.commit()) {
                this.solrClient.commit(this.solrMapper.getCollection());
                this.ackCommittedTuples();
            }
        }
    }

    private void ackCommittedTuples() {
        List<Tuple> toAckTuples = this.getQueuedTuples();
        for (Tuple tuple : toAckTuples) {
            this.collector.ack(tuple);
        }
    }

    private void fail(Tuple tuple, Exception e) {
        this.collector.reportError((Throwable)e);
        if (this.commitStgy == null) {
            this.collector.fail(tuple);
        } else {
            List<Tuple> failedTuples = this.getQueuedTuples();
            this.failQueuedTuples(failedTuples);
        }
    }

    private void failQueuedTuples(List<Tuple> failedTuples) {
        for (Tuple failedTuple : failedTuples) {
            this.collector.fail(failedTuple);
        }
    }

    private List<Tuple> getQueuedTuples() {
        List<Tuple> queuedTuples = this.toCommitTuples;
        this.toCommitTuples = new ArrayList<Tuple>(this.capacity());
        return queuedTuples;
    }

    public Map<String, Object> getComponentConfiguration() {
        if (this.solrConfig.getTickTupleInterval() > 0) {
            this.tickTupleInterval = this.solrConfig.getTickTupleInterval();
        }
        return TupleUtils.putTickFrequencyIntoComponentConfig((Map)super.getComponentConfiguration(), (int)this.tickTupleInterval);
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
    }
}

