/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.cassandra.trident.state;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.storm.cassandra.query.CQLResultSetValuesMapper;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.ITuple;
import org.apache.storm.tuple.Values;

public class TridentResultSetValuesMapper
implements CQLResultSetValuesMapper {
    private Fields outputDeclaredFields;

    public TridentResultSetValuesMapper(Fields outputDeclaredFields) {
        this.outputDeclaredFields = outputDeclaredFields;
    }

    @Override
    public List<List<Values>> map(Session session, Statement statement, ITuple tuple) {
        ArrayList<List<Values>> list = new ArrayList<List<Values>>();
        ResultSet resultSet = session.execute(statement);
        for (Row row : resultSet) {
            final Values values = new Values();
            for (String field : this.outputDeclaredFields) {
                if (tuple.contains(field)) {
                    values.add(tuple.getValueByField(field));
                    continue;
                }
                values.add(row.getObject(field));
            }
            list.add((List<Values>)new LinkedList<Values>(){
                {
                    this.add(values);
                }
            });
        }
        return list;
    }
}

