/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.cassandra.trident.state;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.storm.cassandra.client.SimpleClient;
import org.apache.storm.cassandra.client.SimpleClientProvider;
import org.apache.storm.cassandra.query.CQLResultSetValuesMapper;
import org.apache.storm.cassandra.query.CQLStatementTupleMapper;
import org.apache.storm.topology.FailedException;
import org.apache.storm.trident.operation.TridentCollector;
import org.apache.storm.trident.state.State;
import org.apache.storm.trident.tuple.TridentTuple;
import org.apache.storm.tuple.ITuple;
import org.apache.storm.tuple.Values;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraState
implements State {
    private static final Logger LOG = LoggerFactory.getLogger(CassandraState.class);
    private final Map conf;
    private final Options options;
    private Session session;
    private SimpleClient client;

    protected CassandraState(Map conf, Options options) {
        this.conf = conf;
        this.options = options;
    }

    public void beginCommit(Long txid) {
        LOG.debug("beginCommit is no operation");
    }

    public void commit(Long txid) {
        LOG.debug("commit is no operation");
    }

    public void prepare() {
        Preconditions.checkNotNull((Object)this.options.cqlStatementTupleMapper, (Object)"CassandraState.Options should have cqlStatementTupleMapper");
        this.client = this.options.clientProvider.getClient(this.conf);
        this.session = this.client.connect();
    }

    public void cleanup() {
        try {
            this.session.close();
        }
        catch (Exception e) {
            LOG.warn("Error occurred while closing Session", (Throwable)e);
        }
        finally {
            this.client.close();
        }
    }

    public void updateState(List<TridentTuple> tuples, TridentCollector collector) {
        ArrayList<Statement> statements = new ArrayList<Statement>();
        for (TridentTuple tuple : tuples) {
            statements.addAll(this.options.cqlStatementTupleMapper.map(this.conf, this.session, (ITuple)tuple));
        }
        try {
            if (this.options.batchingType != null) {
                BatchStatement batchStatement = new BatchStatement(this.options.batchingType);
                batchStatement.addAll(statements);
                this.session.execute((Statement)batchStatement);
            } else {
                for (Statement statement : statements) {
                    this.session.execute(statement);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Batch write operation is failed.");
            collector.reportError((Throwable)e);
            throw new FailedException((Throwable)e);
        }
    }

    public List<List<Values>> batchRetrieve(List<TridentTuple> tridentTuples) {
        Preconditions.checkNotNull((Object)this.options.cqlResultSetValuesMapper, (Object)"CassandraState.Options should have cqlResultSetValuesMapper");
        ArrayList<List<Values>> batchRetrieveResult = new ArrayList<List<Values>>();
        try {
            for (TridentTuple tridentTuple : tridentTuples) {
                List<Statement> statements = this.options.cqlStatementTupleMapper.map(this.conf, this.session, (ITuple)tridentTuple);
                for (Statement statement : statements) {
                    List<List<Values>> values = this.options.cqlResultSetValuesMapper.map(this.session, statement, (ITuple)tridentTuple);
                    batchRetrieveResult.addAll(values);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Batch retrieve operation is failed.");
            throw new FailedException((Throwable)e);
        }
        return batchRetrieveResult;
    }

    public static final class Options
    implements Serializable {
        private final SimpleClientProvider clientProvider;
        private CQLStatementTupleMapper cqlStatementTupleMapper;
        private CQLResultSetValuesMapper cqlResultSetValuesMapper;
        private BatchStatement.Type batchingType;

        public Options(SimpleClientProvider clientProvider) {
            this.clientProvider = clientProvider;
        }

        public Options withCQLStatementTupleMapper(CQLStatementTupleMapper cqlStatementTupleMapper) {
            this.cqlStatementTupleMapper = cqlStatementTupleMapper;
            return this;
        }

        public Options withCQLResultSetValuesMapper(CQLResultSetValuesMapper cqlResultSetValuesMapper) {
            this.cqlResultSetValuesMapper = cqlResultSetValuesMapper;
            return this;
        }

        public Options withBatching(BatchStatement.Type batchingType) {
            this.batchingType = batchingType;
            return this;
        }
    }
}

