/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.cassandra.query.impl;

import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.storm.cassandra.query.CQLStatementTupleMapper;
import org.apache.storm.cassandra.query.Column;
import org.apache.storm.cassandra.query.CqlMapper;
import org.apache.storm.cassandra.query.impl.RoutingKeyGenerator;
import org.apache.storm.tuple.ITuple;

public class SimpleCQLStatementMapper
implements CQLStatementTupleMapper {
    private final String queryString;
    private final CqlMapper mapper;
    private final RoutingKeyGenerator rkGenerator;

    public SimpleCQLStatementMapper(String queryString, CqlMapper mapper) {
        this(queryString, mapper, null);
    }

    public SimpleCQLStatementMapper(String queryString, CqlMapper mapper, RoutingKeyGenerator rkGenerator) {
        Preconditions.checkNotNull((Object)queryString, (Object)"Query string must not be null");
        Preconditions.checkNotNull((Object)mapper, (Object)"Mapper should not be null");
        this.queryString = queryString;
        this.mapper = mapper;
        this.rkGenerator = rkGenerator;
    }

    @Override
    public List<Statement> map(Map conf, Session session, ITuple tuple) {
        List<Column> columns = this.mapper.map(tuple);
        SimpleStatement statement = new SimpleStatement(this.queryString, Column.getVals(columns));
        if (this.hasRoutingKeys()) {
            List<ByteBuffer> keys = this.rkGenerator.getRoutingKeys(tuple);
            if (keys.size() == 1) {
                statement.setRoutingKey(keys.get(0));
            } else {
                statement.setRoutingKey(keys.toArray(new ByteBuffer[keys.size()]));
            }
        }
        return Arrays.asList(statement);
    }

    private boolean hasRoutingKeys() {
        return this.rkGenerator != null;
    }
}

