/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.cassandra.query.impl;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ProtocolVersion;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.storm.tuple.ITuple;

public class RoutingKeyGenerator
implements Serializable {
    private List<String> routingKeys;

    public RoutingKeyGenerator(List<String> routingKeys) {
        Preconditions.checkNotNull(routingKeys);
        this.routingKeys = routingKeys;
    }

    public List<ByteBuffer> getRoutingKeys(ITuple tuple) {
        ArrayList<ByteBuffer> keys = new ArrayList<ByteBuffer>(this.routingKeys.size());
        for (String s : this.routingKeys) {
            Object value = tuple.getValueByField(s);
            keys.add(DataType.serializeValue((Object)value, (ProtocolVersion)ProtocolVersion.NEWEST_SUPPORTED));
        }
        return keys;
    }
}

