/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.cassandra.query.impl;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.UDTValue;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.storm.cassandra.query.Column;

public interface PreparedStatementBinder
extends Serializable {
    public BoundStatement apply(PreparedStatement var1, List<Column> var2);

    public static final class CQL3NamedSettersBinder
    implements PreparedStatementBinder {
        @Override
        public BoundStatement apply(PreparedStatement statement, List<Column> columns) {
            Object[] values = Column.getVals(columns);
            BoundStatement boundStatement = statement.bind();
            for (Column col : columns) {
                if (col.isNull()) {
                    boundStatement.setToNull(col.getColumnName());
                    continue;
                }
                CQL3NamedSettersBinder.bind(boundStatement, col.getColumnName(), col.getVal());
            }
            return statement.bind(values);
        }

        static void bind(BoundStatement statement, String name, Object value) {
            if (value instanceof ByteBuffer) {
                statement.setBytes(name, (ByteBuffer)value);
            }
            if (value instanceof Number) {
                if (value instanceof Integer) {
                    statement.setInt(name, ((Integer)value).intValue());
                }
                if (value instanceof Long) {
                    statement.setLong(name, ((Long)value).longValue());
                }
                if (value instanceof Float) {
                    statement.setFloat(name, ((Float)value).floatValue());
                }
                if (value instanceof Double) {
                    statement.setDouble(name, ((Double)value).doubleValue());
                }
                if (value instanceof BigDecimal) {
                    statement.setDecimal(name, (BigDecimal)value);
                }
                if (value instanceof BigInteger) {
                    statement.setVarint(name, (BigInteger)value);
                }
                throw new IllegalArgumentException(String.format("Value of type %s does not correspond to any CQL3 type", value.getClass()));
            }
            if (value instanceof String) {
                statement.setString(name, (String)value);
            }
            if (value instanceof Boolean) {
                statement.setBool(name, ((Boolean)value).booleanValue());
            }
            if (value instanceof InetAddress) {
                statement.setInet(name, (InetAddress)value);
            }
            if (value instanceof Date) {
                statement.setDate(name, (Date)value);
            }
            if (value instanceof UUID) {
                statement.setUUID(name, (UUID)value);
            }
            if (value instanceof List) {
                statement.setList(name, (List)value);
            }
            if (value instanceof Set) {
                statement.setSet(name, (Set)value);
            }
            if (value instanceof Map) {
                statement.setMap(name, (Map)value);
            }
            if (value instanceof UDTValue) {
                statement.setUDTValue(name, (UDTValue)value);
            }
            if (value instanceof TupleValue) {
                statement.setTupleValue(name, (TupleValue)value);
            }
            throw new IllegalArgumentException(String.format("Value of type %s does not correspond to any CQL3 type", value.getClass()));
        }
    }

    public static final class DefaultBinder
    implements PreparedStatementBinder {
        @Override
        public BoundStatement apply(PreparedStatement statement, List<Column> columns) {
            Object[] values = Column.getVals(columns);
            return statement.bind(values);
        }
    }
}

