/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.cassandra.query.impl;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.cassandra.query.CQLStatementTupleMapper;
import org.apache.storm.cassandra.query.Column;
import org.apache.storm.cassandra.query.ContextQuery;
import org.apache.storm.cassandra.query.CqlMapper;
import org.apache.storm.cassandra.query.impl.PreparedStatementBinder;
import org.apache.storm.cassandra.query.impl.RoutingKeyGenerator;
import org.apache.storm.tuple.ITuple;

public class BoundCQLStatementTupleMapper
implements CQLStatementTupleMapper {
    private final ContextQuery contextQuery;
    private final CqlMapper mapper;
    private Map<String, PreparedStatement> cache = new HashMap<String, PreparedStatement>();
    private final RoutingKeyGenerator rkGenerator;
    private final PreparedStatementBinder binder;

    public BoundCQLStatementTupleMapper(ContextQuery contextQuery, CqlMapper mapper, RoutingKeyGenerator rkGenerator, PreparedStatementBinder binder) {
        Preconditions.checkNotNull((Object)contextQuery, (Object)"ContextQuery must not be null");
        Preconditions.checkNotNull((Object)mapper, (Object)"Mapper should not be null");
        this.contextQuery = contextQuery;
        this.mapper = mapper;
        this.rkGenerator = rkGenerator;
        this.binder = binder;
    }

    @Override
    public List<Statement> map(Map config, Session session, ITuple tuple) {
        List<Column> columns = this.mapper.map(tuple);
        String query = this.contextQuery.resolves(config, tuple);
        PreparedStatement statement = this.getPreparedStatement(session, query);
        if (this.hasRoutingKeys()) {
            List<ByteBuffer> keys = this.rkGenerator.getRoutingKeys(tuple);
            if (keys.size() == 1) {
                statement.setRoutingKey(keys.get(0));
            } else {
                statement.setRoutingKey(keys.toArray(new ByteBuffer[keys.size()]));
            }
        }
        return Arrays.asList(this.binder.apply(statement, columns));
    }

    private boolean hasRoutingKeys() {
        return this.rkGenerator != null;
    }

    private PreparedStatement getPreparedStatement(Session session, String query) {
        PreparedStatement statement = this.cache.get(query);
        if (statement == null) {
            statement = session.prepare(query);
            this.cache.put(query, statement);
        }
        return statement;
    }
}

