/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.cassandra.query.impl;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.storm.cassandra.query.CQLStatementTupleMapper;
import org.apache.storm.tuple.ITuple;

public class BatchCQLStatementTupleMapper
implements CQLStatementTupleMapper {
    private final List<CQLStatementTupleMapper> mappers;
    private final BatchStatement.Type type;

    public BatchCQLStatementTupleMapper(BatchStatement.Type type, List<CQLStatementTupleMapper> mappers) {
        this.mappers = new ArrayList<CQLStatementTupleMapper>(mappers);
        this.type = type;
    }

    @Override
    public List<Statement> map(Map conf, Session session, ITuple tuple) {
        BatchStatement batch = new BatchStatement(this.type);
        for (CQLStatementTupleMapper m : this.mappers) {
            batch.addAll(m.map(conf, session, tuple));
        }
        return Arrays.asList(batch);
    }
}

