/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.cassandra.query.builder;

import com.datastax.driver.core.querybuilder.BuiltStatement;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.storm.cassandra.query.CQLStatementBuilder;
import org.apache.storm.cassandra.query.CqlMapper;
import org.apache.storm.cassandra.query.impl.RoutingKeyGenerator;
import org.apache.storm.cassandra.query.impl.SimpleCQLStatementMapper;
import org.apache.storm.cassandra.query.selector.FieldSelector;

public class SimpleCQLStatementMapperBuilder
implements CQLStatementBuilder<SimpleCQLStatementMapper>,
Serializable {
    private final String queryString;
    private CqlMapper mapper;
    private List<String> routingKeys;

    public SimpleCQLStatementMapperBuilder(String queryString) {
        this.queryString = queryString;
    }

    public SimpleCQLStatementMapperBuilder(BuiltStatement builtStatement) {
        this.queryString = builtStatement.getQueryString();
    }

    @Override
    public SimpleCQLStatementMapper build() {
        return new SimpleCQLStatementMapper(this.queryString, this.mapper, this.routingKeys != null ? new RoutingKeyGenerator(this.routingKeys) : null);
    }

    public final SimpleCQLStatementMapperBuilder with(FieldSelector ... fields) {
        this.mapper = new CqlMapper.SelectableCqlMapper(Arrays.asList(fields));
        return this;
    }

    public final SimpleCQLStatementMapperBuilder withRoutingKeys(String ... fields) {
        this.routingKeys = Arrays.asList(fields);
        return this;
    }

    public final SimpleCQLStatementMapperBuilder with(CqlMapper mapper) {
        this.mapper = mapper;
        return this;
    }
}

