/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.cassandra.query.builder;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.storm.cassandra.query.CQLStatementBuilder;
import org.apache.storm.cassandra.query.ContextQuery;
import org.apache.storm.cassandra.query.CqlMapper;
import org.apache.storm.cassandra.query.impl.BoundCQLStatementTupleMapper;
import org.apache.storm.cassandra.query.impl.PreparedStatementBinder;
import org.apache.storm.cassandra.query.impl.RoutingKeyGenerator;
import org.apache.storm.cassandra.query.selector.FieldSelector;

public class BoundCQLStatementMapperBuilder
implements CQLStatementBuilder<BoundCQLStatementTupleMapper>,
Serializable {
    private final ContextQuery contextQuery;
    private CqlMapper mapper;
    private List<String> routingKeys;
    private PreparedStatementBinder binder;

    public BoundCQLStatementMapperBuilder(String cql) {
        this.contextQuery = new ContextQuery.StaticContextQuery(cql);
    }

    public BoundCQLStatementMapperBuilder(ContextQuery contextQuery) {
        this.contextQuery = contextQuery;
    }

    public final BoundCQLStatementMapperBuilder bind(FieldSelector ... fields) {
        this.mapper = new CqlMapper.SelectableCqlMapper(Arrays.asList(fields));
        return this;
    }

    public final BoundCQLStatementMapperBuilder bind(CqlMapper mapper) {
        this.mapper = mapper;
        return this;
    }

    public final BoundCQLStatementMapperBuilder withRoutingKeys(String ... fields) {
        this.routingKeys = Arrays.asList(fields);
        return this;
    }

    public final BoundCQLStatementMapperBuilder byNamedSetters() {
        this.binder = new PreparedStatementBinder.CQL3NamedSettersBinder();
        return this;
    }

    @Override
    public BoundCQLStatementTupleMapper build() {
        return new BoundCQLStatementTupleMapper(this.contextQuery, this.mapper, this.getRoutingKeyGenerator(), this.getStatementBinder());
    }

    private RoutingKeyGenerator getRoutingKeyGenerator() {
        return this.routingKeys != null ? new RoutingKeyGenerator(this.routingKeys) : null;
    }

    private PreparedStatementBinder getStatementBinder() {
        return this.binder != null ? this.binder : new PreparedStatementBinder.DefaultBinder();
    }
}

