/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.cassandra.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.storm.cassandra.query.Column;
import org.apache.storm.cassandra.query.selector.FieldSelector;
import org.apache.storm.tuple.ITuple;

public interface CqlMapper
extends Serializable {
    public List<Column> map(ITuple var1);

    public static final class DefaultCqlMapper
    implements CqlMapper {
        @Override
        public List<Column> map(ITuple tuple) {
            ArrayList<Column> columns = new ArrayList<Column>(tuple.size());
            for (String name : tuple.getFields()) {
                columns.add(new Column<Object>(name, tuple.getValueByField(name)));
            }
            return columns;
        }
    }

    public static final class SelectableCqlMapper
    implements CqlMapper {
        private final List<FieldSelector> selectors;

        public SelectableCqlMapper(List<FieldSelector> selectors) {
            this.selectors = selectors;
        }

        @Override
        public List<Column> map(ITuple tuple) {
            ArrayList<Column> columns = new ArrayList<Column>(this.selectors.size());
            for (FieldSelector selector : this.selectors) {
                columns.add(selector.select(tuple));
            }
            return columns;
        }
    }
}

