/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.cassandra.query;

import java.io.Serializable;
import java.util.Map;
import org.apache.storm.tuple.ITuple;

public interface ContextQuery
extends Serializable {
    public String resolves(Map var1, ITuple var2);

    public static final class BoundQueryNamedByFieldContext
    implements ContextQuery {
        private String fieldName;

        public BoundQueryNamedByFieldContext(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public String resolves(Map config, ITuple tuple) {
            String name = tuple.getStringByField(this.fieldName);
            if (config.containsKey(name)) {
                return (String)config.get(name);
            }
            throw new IllegalArgumentException("Bound query '" + name + "' does not exist in configuration");
        }
    }

    public static final class BoundQueryContext
    implements ContextQuery {
        private String key;

        public BoundQueryContext(String key) {
            this.key = key;
        }

        @Override
        public String resolves(Map config, ITuple tuple) {
            if (config.containsKey(this.key)) {
                return (String)config.get(this.key);
            }
            throw new IllegalArgumentException("Bound query '" + this.key + "' does not exist in configuration");
        }
    }

    public static final class StaticContextQuery
    implements ContextQuery {
        private final String value;

        public StaticContextQuery(String value) {
            this.value = value;
        }

        @Override
        public String resolves(Map config, ITuple tuple) {
            return this.value;
        }
    }
}

