/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.cassandra.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Column<T>
implements Serializable {
    private final String columnName;
    private final T val;

    public Column(String columnName, T val) {
        this.columnName = columnName;
        this.val = val;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public T getVal() {
        return this.val;
    }

    public boolean isNull() {
        return this.val == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Column column = (Column)o;
        if (this.columnName != null ? !this.columnName.equals(column.columnName) : column.columnName != null) {
            return false;
        }
        return !(this.val != null ? !this.val.equals(column.val) : column.val != null);
    }

    public int hashCode() {
        int result = this.columnName != null ? this.columnName.hashCode() : 0;
        result = 31 * result + (this.val != null ? this.val.hashCode() : 0);
        return result;
    }

    public static Object[] getVals(List<Column> columns) {
        ArrayList vals = new ArrayList(columns.size());
        for (Column c : columns) {
            vals.add(c.getVal());
        }
        return vals.toArray();
    }
}

