/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.cassandra.query;

import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.storm.cassandra.query.CQLStatementBuilder;
import org.apache.storm.tuple.ITuple;

public interface CQLStatementTupleMapper
extends Serializable {
    public List<Statement> map(Map var1, Session var2, ITuple var3);

    public static class DynamicCQLStatementTupleMapper
    implements CQLStatementTupleMapper {
        private List<CQLStatementBuilder> builders;

        public DynamicCQLStatementTupleMapper(List<CQLStatementBuilder> builders) {
            this.builders = builders;
        }

        @Override
        public List<Statement> map(Map conf, Session session, ITuple tuple) {
            LinkedList<Statement> statements = new LinkedList<Statement>();
            for (CQLStatementBuilder b : this.builders) {
                statements.addAll(b.build().map(conf, session, tuple));
            }
            return statements;
        }
    }
}

