/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.cassandra.executor.impl;

import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.storm.cassandra.ExecutionResultHandler;
import org.apache.storm.cassandra.executor.AsyncResultHandler;
import org.apache.storm.cassandra.executor.ExecutionResultCollector;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.tuple.Tuple;

public class BatchAsyncResultHandler
implements AsyncResultHandler<List<Tuple>> {
    private ConcurrentLinkedQueue<ExecutionResultCollector> completed;
    private ExecutionResultHandler handler;

    public BatchAsyncResultHandler(ExecutionResultHandler handler) {
        this.handler = handler;
        this.completed = new ConcurrentLinkedQueue();
    }

    @Override
    public void failure(Throwable t, List<Tuple> input) {
        this.completed.offer(new ExecutionResultCollector.FailedCollector(input, t));
    }

    @Override
    public void success(List<Tuple> input) {
        this.completed.offer(new ExecutionResultCollector.SucceedCollector(input));
    }

    @Override
    public void flush(OutputCollector collector) {
        ExecutionResultCollector poll;
        while ((poll = this.completed.poll()) != null) {
            poll.handle(collector, this.handler);
        }
    }
}

