/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.cassandra.executor;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.storm.cassandra.ExecutionResultHandler;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.tuple.Tuple;

public interface ExecutionResultCollector {
    public void handle(OutputCollector var1, ExecutionResultHandler var2);

    public static final class FailedCollector
    implements ExecutionResultCollector {
        private final Throwable cause;
        private final List<Tuple> inputs;

        public FailedCollector(Tuple input, Throwable cause) {
            this(Lists.newArrayList((Object[])new Tuple[]{input}), cause);
        }

        public FailedCollector(List<Tuple> inputs, Throwable cause) {
            this.inputs = inputs;
            this.cause = cause;
        }

        @Override
        public void handle(OutputCollector collector, ExecutionResultHandler handler) {
            handler.onThrowable(this.cause, collector, this.inputs);
        }
    }

    public static final class SucceedCollector
    implements ExecutionResultCollector {
        private final List<Tuple> inputs;

        public SucceedCollector(Tuple input) {
            this(Lists.newArrayList((Object[])new Tuple[]{input}));
        }

        public SucceedCollector(List<Tuple> inputs) {
            this.inputs = inputs;
        }

        @Override
        public void handle(OutputCollector collector, ExecutionResultHandler handler) {
            for (Tuple t : this.inputs) {
                handler.onQuerySuccess(collector, t);
            }
            for (Tuple t : this.inputs) {
                collector.ack(t);
            }
        }
    }
}

