/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.cassandra.executor;

import com.datastax.driver.core.Session;
import org.apache.storm.cassandra.executor.AsyncExecutor;
import org.apache.storm.cassandra.executor.AsyncResultHandler;

public class AsyncExecutorProvider {
    private static final ThreadLocal<AsyncExecutor> localAsyncExecutor = new ThreadLocal();

    public static <T> AsyncExecutor getLocal(Session session, AsyncResultHandler<T> handler) {
        AsyncExecutor<T> executor = localAsyncExecutor.get();
        if (executor == null) {
            executor = new AsyncExecutor<T>(session, handler);
            localAsyncExecutor.set(executor);
        }
        return executor;
    }
}

