/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.cassandra.executor;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.storm.cassandra.executor.AsyncResultHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncExecutor<T>
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncExecutor.class);
    protected Session session;
    protected ExecutorService executorService;
    protected AsyncResultHandler<T> handler;
    private AtomicInteger pending = new AtomicInteger();

    protected AsyncExecutor(Session session, AsyncResultHandler<T> handler) {
        this(session, AsyncExecutor.newSingleThreadExecutor(), handler);
    }

    private AsyncExecutor(Session session, ExecutorService executorService, AsyncResultHandler<T> handler) {
        this.session = session;
        this.executorService = executorService;
        this.handler = handler;
    }

    protected static ExecutorService newSingleThreadExecutor() {
        return Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("cassandra-async-handler-%d").build());
    }

    public List<SettableFuture<T>> execAsync(List<Statement> statements, final T input) {
        ArrayList<SettableFuture<T>> settableFutures = new ArrayList<SettableFuture<T>>(statements.size());
        for (Statement s : statements) {
            settableFutures.add(this.execAsync(s, input, AsyncResultHandler.NO_OP_HANDLER));
        }
        ListenableFuture allAsList = Futures.allAsList(settableFutures);
        Futures.addCallback((ListenableFuture)allAsList, (FutureCallback)new FutureCallback<List<T>>(){

            public void onSuccess(List<T> inputs) {
                AsyncExecutor.this.handler.success(input);
            }

            public void onFailure(Throwable t) {
                AsyncExecutor.this.handler.failure(t, input);
            }
        }, (Executor)this.executorService);
        return settableFutures;
    }

    public SettableFuture<T> execAsync(Statement statement, T inputs) {
        return this.execAsync(statement, inputs, this.handler);
    }

    public SettableFuture<T> execAsync(final Statement statement, final T inputs, final AsyncResultHandler<T> handler) {
        final SettableFuture settableFuture = SettableFuture.create();
        this.pending.incrementAndGet();
        ResultSetFuture future = this.session.executeAsync(statement);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<ResultSet>(){

            public void release() {
                AsyncExecutor.this.pending.decrementAndGet();
            }

            public void onSuccess(ResultSet result) {
                this.release();
                settableFuture.set(inputs);
                handler.success(inputs);
            }

            public void onFailure(Throwable t) {
                LOG.error(String.format("Failed to execute statement '%s' ", statement), t);
                this.release();
                settableFuture.setException(t);
                handler.failure(t, inputs);
            }
        }, (Executor)this.executorService);
        return settableFuture;
    }

    public int getPendingTasksSize() {
        return this.pending.intValue();
    }

    public void shutdown() {
        if (!this.executorService.isShutdown()) {
            LOG.info("shutting down async handler executor");
            this.executorService.shutdownNow();
        }
    }
}

