/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.cassandra.context;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.storm.cassandra.context.BeanFactory;

public class WorkerCtx
implements Serializable {
    private static final ConcurrentMap<Class, BeanFactory<?>> workerCtx = new ConcurrentHashMap();
    private Map<Class, BeanFactory<?>> componentCtx = new HashMap();

    public <T> void register(Class<T> clazz, BeanFactory<T> provider) {
        this.componentCtx.put(clazz, provider);
    }

    protected <T> BeanFactory<T> getBeanfactory(Class<T> clazz) {
        BeanFactory<?> factory = this.componentCtx.get(clazz);
        if (factory == null) {
            throw new RuntimeException("Cannot resolve bean factory for class : " + clazz.getCanonicalName());
        }
        factory.setStormContext(this);
        return factory;
    }

    public <T, K, V> T getWorkerBean(Class<T> clazz, Map<K, V> stormConf) {
        return this.getWorkerBean(clazz, stormConf, false);
    }

    public <T, K, V> T getWorkerBean(Class<T> clazz, Map<K, V> stormConf, boolean force) {
        BeanFactory factory;
        if (force) {
            workerCtx.remove(clazz);
        }
        if ((factory = (BeanFactory)workerCtx.get(clazz)) == null) {
            BeanFactory<T> instance = this.getBeanfactory(clazz).newInstance();
            workerCtx.putIfAbsent(clazz, instance);
            factory = (BeanFactory)workerCtx.get(clazz);
        }
        return factory.get(stormConf);
    }
}

