/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.cassandra.context;

import java.util.Map;
import org.apache.storm.cassandra.context.BeanFactory;
import org.apache.storm.cassandra.context.WorkerCtx;

public abstract class BaseBeanFactory<T>
implements BeanFactory<T> {
    protected WorkerCtx context;
    protected volatile T instance;

    @Override
    public void setStormContext(WorkerCtx context) {
        this.context = context;
    }

    @Override
    public synchronized T get(Map<String, Object> stormConf) {
        if (this.instance != null) {
            return this.instance;
        }
        this.instance = this.make(stormConf);
        return this.instance;
    }

    protected abstract T make(Map<String, Object> var1);

    @Override
    public BeanFactory<T> newInstance() {
        Class<?> clazz = this.getClass();
        try {
            BaseBeanFactory factory = (BaseBeanFactory)clazz.newInstance();
            factory.setStormContext(this.context);
            return factory;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Cannot create a new instance of " + clazz.getSimpleName(), e);
        }
    }
}

