/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.cassandra.client.impl;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.Serializable;
import java.util.Set;
import org.apache.storm.cassandra.client.SimpleClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClient
implements SimpleClient,
Closeable,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultClient.class);
    private String keyspace;
    private Cluster cluster;
    private Session session;

    public DefaultClient(Cluster cluster, String keyspace) {
        Preconditions.checkNotNull((Object)cluster, (Object)"Cluster cannot be 'null");
        this.cluster = cluster;
        this.keyspace = keyspace;
    }

    public Set<Host> getAllHosts() {
        Metadata metadata = this.getMetadata();
        return metadata.getAllHosts();
    }

    public Metadata getMetadata() {
        return this.cluster.getMetadata();
    }

    private String getExecutorName() {
        Thread thread = Thread.currentThread();
        return thread.getName();
    }

    @Override
    public synchronized Session connect() throws NoHostAvailableException {
        if (this.isDisconnected()) {
            LOG.info("Connected to cluster: {}", (Object)this.cluster.getClusterName());
            for (Host host : this.getAllHosts()) {
                LOG.info("Datacenter: {}; Host: {}; Rack: {}", new Object[]{host.getDatacenter(), host.getAddress(), host.getRack()});
            }
            LOG.info("Connect to cluster using keyspace %s", (Object)this.keyspace);
            this.session = this.cluster.connect(this.keyspace);
        } else {
            LOG.warn("{} - Already connected to cluster: {}", (Object)this.getExecutorName(), (Object)this.cluster.getClusterName());
        }
        if (this.session.isClosed()) {
            LOG.warn("Session has been closed - create new one!");
            this.session = this.cluster.newSession();
        }
        return this.session;
    }

    protected boolean isDisconnected() {
        return this.session == null;
    }

    @Override
    public void close() {
        if (this.cluster != null && !this.cluster.isClosed()) {
            LOG.info("Try to close connection to cluster: {}", (Object)this.cluster.getClusterName());
            this.session.close();
            this.cluster.close();
        }
    }

    @Override
    public boolean isClose() {
        return this.cluster.isClosed();
    }
}

