/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.cassandra.client;

import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.PlainTextAuthProvider;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.policies.ExponentialReconnectionPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.datastax.driver.core.policies.RoundRobinPolicy;
import com.datastax.driver.core.policies.TokenAwarePolicy;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.storm.cassandra.client.CassandraConf;
import org.apache.storm.cassandra.context.BaseBeanFactory;

public class ClusterFactory
extends BaseBeanFactory<Cluster> {
    @Override
    protected Cluster make(Map<String, Object> stormConf) {
        CassandraConf cassandraConf = new CassandraConf(stormConf);
        Cluster.Builder cluster = Cluster.builder().withoutJMXReporting().withoutMetrics().addContactPoints(cassandraConf.getNodes()).withPort(cassandraConf.getPort()).withRetryPolicy(cassandraConf.getRetryPolicy()).withReconnectionPolicy((ReconnectionPolicy)new ExponentialReconnectionPolicy(cassandraConf.getReconnectionPolicyBaseMs(), cassandraConf.getReconnectionPolicyMaxMs())).withLoadBalancingPolicy((LoadBalancingPolicy)new TokenAwarePolicy((LoadBalancingPolicy)new RoundRobinPolicy()));
        String username = cassandraConf.getUsername();
        String password = cassandraConf.getPassword();
        if (StringUtils.isNotEmpty((CharSequence)username) && StringUtils.isNotEmpty((CharSequence)password)) {
            cluster.withAuthProvider((AuthProvider)new PlainTextAuthProvider(username, password));
        }
        QueryOptions options = new QueryOptions().setConsistencyLevel(cassandraConf.getConsistencyLevel());
        cluster.withQueryOptions(options);
        return cluster.build();
    }
}

