/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.cassandra.client;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.policies.DefaultRetryPolicy;
import com.datastax.driver.core.policies.DowngradingConsistencyRetryPolicy;
import com.datastax.driver.core.policies.FallthroughRetryPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.storm.utils.Utils;

public class CassandraConf
implements Serializable {
    public static final String CASSANDRA_USERNAME = "cassandra.username";
    public static final String CASSANDRA_PASSWORD = "cassandra.password";
    public static final String CASSANDRA_KEYSPACE = "cassandra.keyspace";
    public static final String CASSANDRA_CONSISTENCY_LEVEL = "cassandra.output.consistencyLevel";
    public static final String CASSANDRA_NODES = "cassandra.nodes";
    public static final String CASSANDRA_PORT = "cassandra.port";
    public static final String CASSANDRA_BATCH_SIZE_ROWS = "cassandra.batch.size.rows";
    public static final String CASSANDRA_RETRY_POLICY = "cassandra.retryPolicy";
    public static final String CASSANDRA_RECONNECT_POLICY_BASE_MS = "cassandra.reconnectionPolicy.baseDelayMs";
    public static final String CASSANDRA_RECONNECT_POLICY_MAX_MS = "cassandra.reconnectionPolicy.maxDelayMs";
    private String username;
    private String password;
    private String keyspace;
    private String[] nodes = new String[]{"localhost"};
    private int port = 9092;
    private ConsistencyLevel consistencyLevel = ConsistencyLevel.ONE;
    private int batchSizeRows = 100;
    private String retryPolicyName;
    private long reconnectionPolicyBaseMs;
    private long reconnectionPolicyMaxMs;

    public CassandraConf() {
    }

    public CassandraConf(Map<String, Object> conf) {
        this.username = (String)Utils.get(conf, (Object)CASSANDRA_USERNAME, null);
        this.password = (String)Utils.get(conf, (Object)CASSANDRA_PASSWORD, null);
        this.keyspace = (String)this.get(conf, CASSANDRA_KEYSPACE);
        this.consistencyLevel = ConsistencyLevel.valueOf((String)((String)Utils.get(conf, (Object)CASSANDRA_CONSISTENCY_LEVEL, (Object)ConsistencyLevel.ONE.name())));
        this.nodes = ((String)Utils.get(conf, (Object)CASSANDRA_NODES, (Object)"localhost")).split(",");
        this.batchSizeRows = Utils.getInt((Object)conf.get(CASSANDRA_BATCH_SIZE_ROWS), (Integer)100);
        this.port = Utils.getInt((Object)conf.get(CASSANDRA_PORT), (Integer)9042);
        this.retryPolicyName = (String)Utils.get(conf, (Object)CASSANDRA_RETRY_POLICY, (Object)DefaultRetryPolicy.class.getSimpleName());
        this.reconnectionPolicyBaseMs = CassandraConf.getLong(conf.get(CASSANDRA_RECONNECT_POLICY_BASE_MS), 100L);
        this.reconnectionPolicyMaxMs = CassandraConf.getLong(conf.get(CASSANDRA_RECONNECT_POLICY_MAX_MS), TimeUnit.MINUTES.toMillis(1L));
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public String[] getNodes() {
        return this.nodes;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public int getBatchSizeRows() {
        return this.batchSizeRows;
    }

    public int getPort() {
        return this.port;
    }

    public long getReconnectionPolicyBaseMs() {
        return this.reconnectionPolicyBaseMs;
    }

    public long getReconnectionPolicyMaxMs() {
        return this.reconnectionPolicyMaxMs;
    }

    public RetryPolicy getRetryPolicy() {
        if (this.retryPolicyName.equals(DowngradingConsistencyRetryPolicy.class.getSimpleName())) {
            return DowngradingConsistencyRetryPolicy.INSTANCE;
        }
        if (this.retryPolicyName.equals(FallthroughRetryPolicy.class.getSimpleName())) {
            return FallthroughRetryPolicy.INSTANCE;
        }
        if (this.retryPolicyName.equals(DefaultRetryPolicy.class.getSimpleName())) {
            return DefaultRetryPolicy.INSTANCE;
        }
        throw new IllegalArgumentException("Unknown cassandra retry policy " + this.retryPolicyName);
    }

    private <T> T get(Map<String, Object> conf, String key) {
        Object o = conf.get(key);
        if (o == null) {
            throw new IllegalArgumentException("No '" + key + "' value found in configuration!");
        }
        return (T)o;
    }

    public static Long getLong(Object o, Long defaultValue) {
        if (null == o) {
            return defaultValue;
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        if (o instanceof String) {
            return Long.parseLong((String)o);
        }
        throw new IllegalArgumentException("Don't know how to convert " + o + " to long");
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("username", (Object)this.username).add("password", (Object)this.password).add("keyspace", (Object)this.keyspace).add("nodes", (Object)this.nodes).add("port", this.port).add("consistencyLevel", (Object)this.consistencyLevel).add("batchSizeRows", this.batchSizeRows).add("retryPolicyName", (Object)this.retryPolicyName).add("reconnectionPolicyBaseMs", this.reconnectionPolicyBaseMs).add("reconnectionPolicyMaxMs", this.reconnectionPolicyMaxMs).toString();
    }
}

