/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.cassandra.bolt;

import com.datastax.driver.core.BatchStatement;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.storm.cassandra.bolt.PairBatchStatementTuples;
import org.apache.storm.cassandra.bolt.PairStatementTuple;
import org.apache.storm.tuple.Tuple;

public class GroupingBatchBuilder
implements Iterable<PairBatchStatementTuples> {
    private int batchSizeRows;
    private List<PairStatementTuple> statements;

    public GroupingBatchBuilder(int batchSizeRows, List<PairStatementTuple> statements) {
        this.batchSizeRows = batchSizeRows;
        this.statements = statements;
    }

    @Override
    public Iterator<PairBatchStatementTuples> iterator() {
        return this.build().iterator();
    }

    private Iterable<PairBatchStatementTuples> build() {
        Iterable partition = Iterables.partition(this.statements, (int)this.batchSizeRows);
        return Iterables.transform((Iterable)partition, (Function)new Function<List<PairStatementTuple>, PairBatchStatementTuples>(){

            public PairBatchStatementTuples apply(List<PairStatementTuple> l) {
                LinkedList<Tuple> inputs = new LinkedList<Tuple>();
                BatchStatement batch = new BatchStatement(BatchStatement.Type.UNLOGGED);
                for (PairStatementTuple pair : l) {
                    batch.add(pair.getStatement());
                    inputs.add(pair.getTuple());
                }
                return new PairBatchStatementTuples(inputs, batch);
            }
        });
    }
}

