/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.cassandra.bolt;

import com.datastax.driver.core.Statement;
import java.util.List;
import org.apache.storm.cassandra.bolt.BaseCassandraBolt;
import org.apache.storm.cassandra.executor.AsyncResultHandler;
import org.apache.storm.cassandra.executor.impl.SingleAsyncResultHandler;
import org.apache.storm.cassandra.query.CQLStatementTupleMapper;
import org.apache.storm.tuple.ITuple;
import org.apache.storm.tuple.Tuple;

public class CassandraWriterBolt
extends BaseCassandraBolt<Tuple> {
    private AsyncResultHandler<Tuple> asyncResultHandler;

    public CassandraWriterBolt(CQLStatementTupleMapper tupleMapper) {
        super(tupleMapper);
    }

    @Override
    protected AsyncResultHandler<Tuple> getAsyncHandler() {
        if (this.asyncResultHandler == null) {
            this.asyncResultHandler = new SingleAsyncResultHandler(this.getResultHandler());
        }
        return this.asyncResultHandler;
    }

    protected void process(Tuple input) {
        List<Statement> statements = this.getMapper().map(this.stormConfig, this.session, (ITuple)input);
        if (statements.size() == 1) {
            this.getAsyncExecutor().execAsync(statements.get(0), input);
        } else {
            this.getAsyncExecutor().execAsync(statements, input);
        }
    }
}

