/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.cassandra.bolt;

import com.datastax.driver.core.Session;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import java.util.HashMap;
import java.util.Map;
import org.apache.storm.Config;
import org.apache.storm.cassandra.BaseExecutionResultHandler;
import org.apache.storm.cassandra.CassandraContext;
import org.apache.storm.cassandra.ExecutionResultHandler;
import org.apache.storm.cassandra.client.CassandraConf;
import org.apache.storm.cassandra.client.SimpleClient;
import org.apache.storm.cassandra.client.SimpleClientProvider;
import org.apache.storm.cassandra.executor.AsyncExecutor;
import org.apache.storm.cassandra.executor.AsyncExecutorProvider;
import org.apache.storm.cassandra.executor.AsyncResultHandler;
import org.apache.storm.cassandra.query.CQLStatementTupleMapper;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.base.BaseTickTupleAwareRichBolt;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCassandraBolt<T>
extends BaseTickTupleAwareRichBolt {
    private static final Logger LOG = LoggerFactory.getLogger(BaseCassandraBolt.class);
    protected OutputCollector outputCollector;
    protected SimpleClientProvider clientProvider;
    protected SimpleClient client;
    protected Session session;
    protected Map stormConfig;
    protected CassandraConf cassandraConfConfig;
    private CQLStatementTupleMapper mapper;
    private ExecutionResultHandler resultHandler;
    private transient Map<String, Fields> outputsFields = new HashMap<String, Fields>();

    public BaseCassandraBolt(CQLStatementTupleMapper mapper, SimpleClientProvider clientProvider) {
        this.mapper = mapper;
        this.clientProvider = clientProvider;
    }

    public BaseCassandraBolt(CQLStatementTupleMapper tupleMapper) {
        this(tupleMapper, new CassandraContext());
    }

    public void prepare(Map stormConfig, TopologyContext topologyContext, OutputCollector outputCollector) {
        this.outputCollector = outputCollector;
        this.stormConfig = stormConfig;
        this.cassandraConfConfig = new CassandraConf(stormConfig);
        this.client = this.clientProvider.getClient(this.stormConfig);
        try {
            this.session = this.client.connect();
        }
        catch (NoHostAvailableException e) {
            outputCollector.reportError((Throwable)e);
        }
    }

    public BaseCassandraBolt withResultHandler(ExecutionResultHandler resultHandler) {
        this.resultHandler = resultHandler;
        return this;
    }

    public BaseCassandraBolt withOutputFields(Fields fields) {
        this.outputsFields.put("default", fields);
        return this;
    }

    public BaseCassandraBolt withStreamOutputFields(String stream, Fields fields) {
        if (stream == null || stream.length() == 0) {
            throw new IllegalArgumentException("'stream' should not be null");
        }
        this.outputsFields.put(stream, fields);
        return this;
    }

    protected ExecutionResultHandler getResultHandler() {
        if (this.resultHandler == null) {
            this.resultHandler = new BaseExecutionResultHandler();
        }
        return this.resultHandler;
    }

    protected CQLStatementTupleMapper getMapper() {
        return this.mapper;
    }

    protected abstract AsyncResultHandler<T> getAsyncHandler();

    protected AsyncExecutor<T> getAsyncExecutor() {
        return AsyncExecutorProvider.getLocal(this.session, this.getAsyncHandler());
    }

    public final void execute(Tuple input) {
        this.getAsyncHandler().flush(this.outputCollector);
        super.execute(input);
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        Fields fields = this.outputsFields.remove("default");
        if (fields != null) {
            declarer.declare(fields);
        }
        for (Map.Entry<String, Fields> entry : this.outputsFields.entrySet()) {
            declarer.declareStream(entry.getKey(), entry.getValue());
        }
    }

    public Map<String, Object> getComponentConfiguration() {
        Config conf = new Config();
        conf.put((Object)"topology.tick.tuple.freq.secs", (Object)1);
        return conf;
    }

    public void cleanup() {
        this.getAsyncExecutor().shutdown();
        this.getAsyncHandler().flush(this.outputCollector);
        this.client.close();
    }
}

