/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.cassandra;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.hash.Hashing;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.storm.generated.GlobalStreamId;
import org.apache.storm.grouping.CustomStreamGrouping;
import org.apache.storm.task.WorkerTopologyContext;
import org.apache.storm.topology.FailedException;
import org.apache.storm.tuple.Fields;

public class Murmur3StreamGrouping
implements CustomStreamGrouping {
    private List<Integer> targetTasks;
    private List<Integer> partitionKeyIndexes;
    private List<String> partitionKeyNames;

    public Murmur3StreamGrouping(String ... partitionKeyNames) {
        this(Arrays.asList(partitionKeyNames));
    }

    public Murmur3StreamGrouping(List<String> partitionKeyNames) {
        this.partitionKeyNames = partitionKeyNames;
    }

    public void prepare(WorkerTopologyContext context, GlobalStreamId stream, List<Integer> targetTasks) {
        this.targetTasks = targetTasks;
        this.partitionKeyIndexes = new ArrayList<Integer>();
        Fields componentOutputFields = context.getComponentOutputFields(stream);
        for (String partitionKeyName : this.partitionKeyNames) {
            this.partitionKeyIndexes.add(componentOutputFields.fieldIndex(partitionKeyName));
        }
    }

    public List<Integer> chooseTasks(int taskId, List<Object> values) {
        try {
            int n = Math.abs((int)Murmur3StreamGrouping.hashes(this.getKeyValues(values)) % this.targetTasks.size());
            return Lists.newArrayList((Object[])new Integer[]{this.targetTasks.get(n)});
        }
        catch (IOException e) {
            throw new FailedException((Throwable)e);
        }
    }

    private List<Object> getKeyValues(List<Object> values) {
        ArrayList<Object> keys = new ArrayList<Object>();
        for (Integer idx : this.partitionKeyIndexes) {
            keys.add(values.get(idx));
        }
        return keys;
    }

    @VisibleForTesting
    public static long hashes(List<Object> values) throws IOException {
        byte[] keyBytes;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             DataOutputStream out = new DataOutputStream(bos);){
            for (Object key : values) {
                byte[] arr = ((String)key).getBytes("UTF-8");
                out.writeShort(arr.length);
                out.write(arr, 0, arr.length);
                out.writeByte(0);
            }
            out.flush();
            keyBytes = bos.toByteArray();
        }
        return Hashing.murmur3_128().hashBytes(keyBytes).asLong();
    }
}

