/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.cassandra;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.querybuilder.BuiltStatement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.storm.cassandra.query.CQLStatementBuilder;
import org.apache.storm.cassandra.query.CQLStatementTupleMapper;
import org.apache.storm.cassandra.query.ContextQuery;
import org.apache.storm.cassandra.query.CqlMapper;
import org.apache.storm.cassandra.query.builder.BoundCQLStatementMapperBuilder;
import org.apache.storm.cassandra.query.builder.SimpleCQLStatementMapperBuilder;
import org.apache.storm.cassandra.query.impl.BatchCQLStatementTupleMapper;
import org.apache.storm.cassandra.query.selector.FieldSelector;

public class DynamicStatementBuilder
implements Serializable {
    private DynamicStatementBuilder() {
    }

    public static final SimpleCQLStatementMapperBuilder simpleQuery(String queryString) {
        return new SimpleCQLStatementMapperBuilder(queryString);
    }

    public static final SimpleCQLStatementMapperBuilder simpleQuery(BuiltStatement builtStatement) {
        return new SimpleCQLStatementMapperBuilder(builtStatement);
    }

    public static final BoundCQLStatementMapperBuilder boundQuery(String cql) {
        return new BoundCQLStatementMapperBuilder(cql);
    }

    public static final BoundCQLStatementMapperBuilder boundQuery(ContextQuery field) {
        return new BoundCQLStatementMapperBuilder(field);
    }

    public static final CQLStatementTupleMapper async(CQLStatementBuilder ... builders) {
        return new CQLStatementTupleMapper.DynamicCQLStatementTupleMapper(Arrays.asList(builders));
    }

    public static final BatchCQLStatementTupleMapper loggedBatch(CQLStatementBuilder ... builders) {
        return DynamicStatementBuilder.newBatchStatementBuilder(BatchStatement.Type.LOGGED, builders);
    }

    public static final BatchCQLStatementTupleMapper counterBatch(CQLStatementBuilder ... builders) {
        return DynamicStatementBuilder.newBatchStatementBuilder(BatchStatement.Type.COUNTER, builders);
    }

    public static final BatchCQLStatementTupleMapper unLoggedBatch(CQLStatementBuilder ... builders) {
        return DynamicStatementBuilder.newBatchStatementBuilder(BatchStatement.Type.UNLOGGED, builders);
    }

    private static BatchCQLStatementTupleMapper newBatchStatementBuilder(BatchStatement.Type type, CQLStatementBuilder[] builders) {
        ArrayList<CQLStatementTupleMapper> mappers = new ArrayList<CQLStatementTupleMapper>(builders.length);
        for (CQLStatementBuilder b : Arrays.asList(builders)) {
            mappers.add((CQLStatementTupleMapper)b.build());
        }
        return new BatchCQLStatementTupleMapper(type, mappers);
    }

    public static final ContextQuery named(String name) {
        return new ContextQuery.BoundQueryContext(name);
    }

    public static final ContextQuery namedByField(String fieldName) {
        return new ContextQuery.BoundQueryNamedByFieldContext(fieldName);
    }

    public static final FieldSelector field(String name) {
        return new FieldSelector(name);
    }

    public static final FieldSelector[] fields(String ... fields) {
        int size = fields.length;
        ArrayList<FieldSelector> fl = new ArrayList<FieldSelector>(size);
        for (int i = 0; i < size; ++i) {
            fl.add(new FieldSelector(fields[i]));
        }
        return fl.toArray(new FieldSelector[size]);
    }

    public static final CqlMapper.DefaultCqlMapper all() {
        return new CqlMapper.DefaultCqlMapper();
    }
}

