/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.cassandra;

import com.datastax.driver.core.Cluster;
import java.util.Map;
import org.apache.storm.cassandra.client.CassandraConf;
import org.apache.storm.cassandra.client.ClusterFactory;
import org.apache.storm.cassandra.client.SimpleClient;
import org.apache.storm.cassandra.client.SimpleClientProvider;
import org.apache.storm.cassandra.client.impl.DefaultClient;
import org.apache.storm.cassandra.context.BaseBeanFactory;
import org.apache.storm.cassandra.context.WorkerCtx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraContext
extends WorkerCtx
implements SimpleClientProvider {
    public CassandraContext() {
        this.register(SimpleClient.class, new ClientFactory());
        this.register(CassandraConf.class, new CassandraConfFactory());
        this.register(Cluster.class, new ClusterFactory());
    }

    @Override
    public SimpleClient getClient(Map<String, Object> config) {
        SimpleClient client = this.getWorkerBean(SimpleClient.class, config);
        if (client.isClose()) {
            client = this.getWorkerBean(SimpleClient.class, config, true);
        }
        return client;
    }

    public static final class ClientFactory
    extends BaseBeanFactory<SimpleClient> {
        private static final Logger LOG = LoggerFactory.getLogger(ClientFactory.class);

        @Override
        protected SimpleClient make(Map<String, Object> stormConf) {
            Cluster cluster = this.context.getWorkerBean(Cluster.class, stormConf);
            if (cluster.isClosed()) {
                LOG.warn("Cluster is closed - trigger new initialization!");
                cluster = this.context.getWorkerBean(Cluster.class, stormConf, true);
            }
            CassandraConf config = this.context.getWorkerBean(CassandraConf.class, stormConf);
            return new DefaultClient(cluster, config.getKeyspace());
        }
    }

    public static final class CassandraConfFactory
    extends BaseBeanFactory<CassandraConf> {
        @Override
        protected CassandraConf make(Map<String, Object> stormConf) {
            return new CassandraConf(stormConf);
        }
    }
}

