/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.cassandra;

import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.exceptions.QueryValidationException;
import com.datastax.driver.core.exceptions.ReadTimeoutException;
import com.datastax.driver.core.exceptions.UnavailableException;
import com.datastax.driver.core.exceptions.WriteTimeoutException;
import org.apache.storm.cassandra.AbstractExecutionResultHandler;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.tuple.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseExecutionResultHandler
extends AbstractExecutionResultHandler {
    private static final Logger LOG = LoggerFactory.getLogger(BaseExecutionResultHandler.class);

    @Override
    public void onQueryValidationException(QueryValidationException e, OutputCollector collector, Tuple tuple) {
        this.onDriverException((DriverException)e, collector, tuple);
    }

    @Override
    public void onReadTimeoutException(ReadTimeoutException e, OutputCollector collector, Tuple tuple) {
        this.onDriverException((DriverException)e, collector, tuple);
    }

    @Override
    public void onWriteTimeoutException(WriteTimeoutException e, OutputCollector collector, Tuple tuple) {
        this.onDriverException((DriverException)e, collector, tuple);
    }

    @Override
    public void onUnavailableException(UnavailableException e, OutputCollector collector, Tuple tuple) {
        this.onDriverException((DriverException)e, collector, tuple);
    }

    @Override
    public void onQuerySuccess(OutputCollector collector, Tuple tuple) {
    }

    protected void onDriverException(DriverException e, OutputCollector collector, Tuple tuple) {
        LOG.error("An error occurred while executing cassandra statement", (Throwable)e);
        collector.fail(tuple);
        collector.reportError((Throwable)e);
    }
}

