/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.cassandra;

import com.datastax.driver.core.exceptions.QueryValidationException;
import com.datastax.driver.core.exceptions.ReadTimeoutException;
import com.datastax.driver.core.exceptions.UnavailableException;
import com.datastax.driver.core.exceptions.WriteTimeoutException;
import java.util.List;
import org.apache.storm.cassandra.ExecutionResultHandler;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.tuple.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExecutionResultHandler
implements ExecutionResultHandler {
    public static final Logger LOG = LoggerFactory.getLogger(AbstractExecutionResultHandler.class);

    @Override
    public void onThrowable(Throwable t, OutputCollector collector, Tuple i) {
        if (t instanceof QueryValidationException) {
            this.onQueryValidationException((QueryValidationException)t, collector, i);
        } else if (t instanceof ReadTimeoutException) {
            this.onReadTimeoutException((ReadTimeoutException)t, collector, i);
        } else if (t instanceof WriteTimeoutException) {
            this.onWriteTimeoutException((WriteTimeoutException)t, collector, i);
        } else if (t instanceof UnavailableException) {
            this.onUnavailableException((UnavailableException)t, collector, i);
        } else {
            collector.reportError(t);
            collector.fail(i);
        }
    }

    @Override
    public void onThrowable(Throwable t, OutputCollector collector, List<Tuple> tl) {
        for (Tuple i : tl) {
            this.onThrowable(t, collector, i);
        }
    }
}

