/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.spout;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.storm.hdfs.spout.AbstractFileReader;
import org.apache.storm.hdfs.spout.FileOffset;
import org.apache.storm.hdfs.spout.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceFileReader<Key extends Writable, Value extends Writable>
extends AbstractFileReader {
    private static final Logger LOG = LoggerFactory.getLogger(SequenceFileReader.class);
    public static final String[] defaultFields = new String[]{"key", "value"};
    private static final int DEFAULT_BUFF_SIZE = 4096;
    public static final String BUFFER_SIZE = "hdfsspout.reader.buffer.bytes";
    private final SequenceFile.Reader reader;
    private final Offset offset;
    private final Key key;
    private final Value value;

    public SequenceFileReader(FileSystem fs, Path file, Map conf) throws IOException {
        super(fs, file);
        int bufferSize = !conf.containsKey(BUFFER_SIZE) ? 4096 : Integer.parseInt(conf.get(BUFFER_SIZE).toString());
        this.reader = new SequenceFile.Reader(fs.getConf(), new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)file), SequenceFile.Reader.bufferSize((int)bufferSize)});
        this.key = (Writable)ReflectionUtils.newInstance((Class)this.reader.getKeyClass(), (Configuration)fs.getConf());
        this.value = (Writable)ReflectionUtils.newInstance((Class)this.reader.getValueClass(), (Configuration)fs.getConf());
        this.offset = new Offset(0L, 0L, 0L);
    }

    public SequenceFileReader(FileSystem fs, Path file, Map conf, String offset) throws IOException {
        super(fs, file);
        int bufferSize = !conf.containsKey(BUFFER_SIZE) ? 4096 : Integer.parseInt(conf.get(BUFFER_SIZE).toString());
        this.offset = new Offset(offset);
        this.reader = new SequenceFile.Reader(fs.getConf(), new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)file), SequenceFile.Reader.bufferSize((int)bufferSize)});
        this.key = (Writable)ReflectionUtils.newInstance((Class)this.reader.getKeyClass(), (Configuration)fs.getConf());
        this.value = (Writable)ReflectionUtils.newInstance((Class)this.reader.getValueClass(), (Configuration)fs.getConf());
        SequenceFileReader.skipToOffset(this.reader, this.offset, this.key);
    }

    private static <K> void skipToOffset(SequenceFile.Reader reader, Offset offset, K key) throws IOException {
        reader.sync(offset.lastSyncPoint);
        int i = 0;
        while ((long)i < offset.recordsSinceLastSync) {
            reader.next(key);
            ++i;
        }
    }

    @Override
    public List<Object> next() throws IOException, ParseException {
        if (this.reader.next(this.key, this.value)) {
            ArrayList<Object> result = new ArrayList<Object>(2);
            Collections.addAll(result, this.key, this.value);
            this.offset.increment(this.reader.syncSeen(), this.reader.getPosition());
            return result;
        }
        return null;
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            LOG.warn("Ignoring error when closing file " + this.getFilePath(), (Throwable)e);
        }
    }

    @Override
    public Offset getFileOffset() {
        return this.offset;
    }

    public static class Offset
    implements FileOffset {
        public long lastSyncPoint;
        public long recordsSinceLastSync;
        public long currentRecord;
        private long currRecordEndOffset;
        private long prevRecordEndOffset;

        public Offset(long lastSyncPoint, long recordsSinceLastSync, long currentRecord) {
            this(lastSyncPoint, recordsSinceLastSync, currentRecord, 0L, 0L);
        }

        public Offset(long lastSyncPoint, long recordsSinceLastSync, long currentRecord, long currRecordEndOffset, long prevRecordEndOffset) {
            this.lastSyncPoint = lastSyncPoint;
            this.recordsSinceLastSync = recordsSinceLastSync;
            this.currentRecord = currentRecord;
            this.prevRecordEndOffset = prevRecordEndOffset;
            this.currRecordEndOffset = currRecordEndOffset;
        }

        public Offset(String offset) {
            try {
                if (offset == null) {
                    throw new IllegalArgumentException("offset cannot be null");
                }
                if (offset.equalsIgnoreCase("0")) {
                    this.lastSyncPoint = 0L;
                    this.recordsSinceLastSync = 0L;
                    this.currentRecord = 0L;
                    this.prevRecordEndOffset = 0L;
                    this.currRecordEndOffset = 0L;
                } else {
                    String[] parts = offset.split(":");
                    this.lastSyncPoint = Long.parseLong(parts[0].split("=")[1]);
                    this.recordsSinceLastSync = Long.parseLong(parts[1].split("=")[1]);
                    this.currentRecord = Long.parseLong(parts[2].split("=")[1]);
                    this.prevRecordEndOffset = 0L;
                    this.currRecordEndOffset = 0L;
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("'" + offset + "' cannot be interpreted. It is not in expected format for SequenceFileReader. Format e.g. {sync=123:afterSync=345:record=67}");
            }
        }

        public String toString() {
            return "{sync=" + this.lastSyncPoint + ":afterSync=" + this.recordsSinceLastSync + ":record=" + this.currentRecord + ":}";
        }

        @Override
        public boolean isNextOffset(FileOffset rhs) {
            if (rhs instanceof Offset) {
                Offset other = (Offset)rhs;
                return other.currentRecord > this.currentRecord + 1L;
            }
            return false;
        }

        @Override
        public int compareTo(FileOffset o) {
            Offset rhs = (Offset)o;
            if (this.currentRecord < rhs.currentRecord) {
                return -1;
            }
            if (this.currentRecord == rhs.currentRecord) {
                return 0;
            }
            return 1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Offset)) {
                return false;
            }
            Offset offset = (Offset)o;
            return this.currentRecord == offset.currentRecord;
        }

        public int hashCode() {
            return (int)(this.currentRecord ^ this.currentRecord >>> 32);
        }

        void increment(boolean syncSeen, long newBytePosition) {
            if (!syncSeen) {
                ++this.recordsSinceLastSync;
            } else {
                this.recordsSinceLastSync = 1L;
                this.lastSyncPoint = this.prevRecordEndOffset;
            }
            ++this.currentRecord;
            this.prevRecordEndOffset = this.currRecordEndOffset;
            this.currentRecord = newBytePosition;
        }

        @Override
        public Offset clone() {
            return new Offset(this.lastSyncPoint, this.recordsSinceLastSync, this.currentRecord, this.currRecordEndOffset, this.prevRecordEndOffset);
        }
    }
}

