/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.bolt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.storm.hdfs.bolt.format.FileNameFormat;
import org.apache.storm.hdfs.bolt.rotation.FileRotationPolicy;
import org.apache.storm.hdfs.bolt.rotation.TimedRotationPolicy;
import org.apache.storm.hdfs.bolt.sync.SyncPolicy;
import org.apache.storm.hdfs.common.rotation.RotationAction;
import org.apache.storm.hdfs.common.security.HdfsSecurityUtil;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.base.BaseRichBolt;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.utils.TupleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHdfsBolt
extends BaseRichBolt {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractHdfsBolt.class);
    private static final Integer DEFAULT_RETRY_COUNT = 3;
    private static final int DEFAULT_TICK_TUPLE_INTERVAL_SECS = 15;
    protected ArrayList<RotationAction> rotationActions = new ArrayList();
    private Path currentFile;
    protected OutputCollector collector;
    protected transient FileSystem fs;
    protected SyncPolicy syncPolicy;
    protected FileRotationPolicy rotationPolicy;
    protected FileNameFormat fileNameFormat;
    protected int rotation = 0;
    protected String fsUrl;
    protected String configKey;
    protected transient Object writeLock;
    protected transient Timer rotationTimer;
    private List<Tuple> tupleBatch = new LinkedList<Tuple>();
    protected long offset = 0L;
    protected Integer fileRetryCount = DEFAULT_RETRY_COUNT;
    protected Integer tickTupleInterval = 15;
    protected transient Configuration hdfsConfig;

    protected void rotateOutputFile() throws IOException {
        this.rotateOutputFile(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rotateOutputFile(boolean createNewFile) throws IOException {
        LOG.info("Rotating output file...");
        long start = System.currentTimeMillis();
        Object object = this.writeLock;
        synchronized (object) {
            this.closeOutputFile();
            ++this.rotation;
            LOG.info("Performing {} file rotation actions.", (Object)this.rotationActions.size());
            for (RotationAction action : this.rotationActions) {
                action.execute(this.fs, this.currentFile);
            }
            if (createNewFile) {
                Path newFile;
                this.currentFile = newFile = this.createOutputFile();
            }
        }
        long time = System.currentTimeMillis() - start;
        LOG.info("File rotation took {} ms.", (Object)time);
    }

    public final void prepare(Map conf, TopologyContext topologyContext, OutputCollector collector) {
        this.writeLock = new Object();
        if (this.syncPolicy == null) {
            throw new IllegalStateException("SyncPolicy must be specified.");
        }
        if (this.rotationPolicy == null) {
            throw new IllegalStateException("RotationPolicy must be specified.");
        }
        if (this.fsUrl == null) {
            throw new IllegalStateException("File system URL must be specified.");
        }
        this.collector = collector;
        this.fileNameFormat.prepare(conf, topologyContext);
        this.hdfsConfig = new Configuration();
        Map map = (Map)conf.get(this.configKey);
        if (map != null) {
            for (String key : map.keySet()) {
                this.hdfsConfig.set(key, String.valueOf(map.get(key)));
            }
        }
        try {
            HdfsSecurityUtil.login(conf, this.hdfsConfig);
            this.doPrepare(conf, topologyContext, collector);
            this.currentFile = this.createOutputFile();
        }
        catch (Exception e) {
            throw new RuntimeException("Error preparing HdfsBolt: " + e.getMessage(), e);
        }
        if (this.rotationPolicy instanceof TimedRotationPolicy) {
            long interval = ((TimedRotationPolicy)this.rotationPolicy).getInterval();
            this.rotationTimer = new Timer(true);
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    try {
                        AbstractHdfsBolt.this.rotateOutputFile();
                    }
                    catch (IOException e) {
                        LOG.warn("IOException during scheduled file rotation.", (Throwable)e);
                    }
                }
            };
            this.rotationTimer.scheduleAtFixedRate(task, interval, interval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(Tuple tuple) {
        Object object = this.writeLock;
        synchronized (object) {
            boolean forceSync = false;
            if (TupleUtils.isTick((Tuple)tuple)) {
                LOG.debug("TICK! forcing a file system flush");
                this.collector.ack(tuple);
                forceSync = true;
            } else {
                try {
                    this.writeTuple(tuple);
                    this.tupleBatch.add(tuple);
                }
                catch (IOException e) {
                    LOG.info("Tuple failed to write, forcing a flush of existing data.");
                    this.collector.reportError((Throwable)e);
                    forceSync = true;
                    this.collector.fail(tuple);
                }
            }
            if (this.syncPolicy.mark(tuple, this.offset) || forceSync && this.tupleBatch.size() > 0) {
                int attempts = 0;
                boolean success = false;
                IOException lastException = null;
                while (!success && attempts < this.fileRetryCount) {
                    ++attempts;
                    try {
                        this.syncTuples();
                        LOG.debug("Data synced to filesystem. Ack'ing [{}] tuples", (Object)this.tupleBatch.size());
                        for (Tuple t : this.tupleBatch) {
                            this.collector.ack(t);
                        }
                        this.tupleBatch.clear();
                        this.syncPolicy.reset();
                        success = true;
                    }
                    catch (IOException e) {
                        LOG.warn("Data could not be synced to filesystem on attempt [{}]", (Object)attempts);
                        this.collector.reportError((Throwable)e);
                        lastException = e;
                    }
                }
                if (!success) {
                    LOG.warn("Data could not be synced to filesystem, failing this batch of tuples");
                    for (Tuple t : this.tupleBatch) {
                        this.collector.fail(t);
                    }
                    this.tupleBatch.clear();
                    throw new RuntimeException("Sync failed [" + attempts + "] times.", lastException);
                }
            }
            if (this.rotationPolicy.mark(tuple, this.offset)) {
                try {
                    this.rotateOutputFile();
                    this.rotationPolicy.reset();
                    this.offset = 0L;
                }
                catch (IOException e) {
                    this.collector.reportError((Throwable)e);
                    LOG.warn("File could not be rotated");
                }
            }
        }
    }

    public Map<String, Object> getComponentConfiguration() {
        return TupleUtils.putTickFrequencyIntoComponentConfig((Map)super.getComponentConfiguration(), (int)this.tickTupleInterval);
    }

    public void declareOutputFields(OutputFieldsDeclarer outputFieldsDeclarer) {
    }

    public void cleanup() {
        try {
            this.rotateOutputFile(false);
        }
        catch (IOException e) {
            LOG.warn("IOException during scheduled file rotation.");
        }
    }

    protected abstract void writeTuple(Tuple var1) throws IOException;

    protected abstract void syncTuples() throws IOException;

    protected abstract void closeOutputFile() throws IOException;

    protected abstract Path createOutputFile() throws IOException;

    protected abstract void doPrepare(Map var1, TopologyContext var2, OutputCollector var3) throws IOException;
}

