/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.blobstore;

import java.util.Iterator;
import java.util.Map;
import org.apache.storm.blobstore.AtomicOutputStream;
import org.apache.storm.blobstore.ClientBlobStore;
import org.apache.storm.blobstore.InputStreamWithMeta;
import org.apache.storm.generated.AuthorizationException;
import org.apache.storm.generated.KeyAlreadyExistsException;
import org.apache.storm.generated.KeyNotFoundException;
import org.apache.storm.generated.ReadableBlobMeta;
import org.apache.storm.generated.SettableBlobMeta;
import org.apache.storm.hdfs.blobstore.HdfsBlobStore;
import org.apache.storm.utils.NimbusClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsClientBlobStore
extends ClientBlobStore {
    private static final Logger LOG = LoggerFactory.getLogger(HdfsClientBlobStore.class);
    private HdfsBlobStore _blobStore;
    private Map _conf;

    public void prepare(Map conf) {
        this._conf = conf;
        this._blobStore = new HdfsBlobStore();
        this._blobStore.prepare(conf, null, null);
    }

    public AtomicOutputStream createBlobToExtend(String key, SettableBlobMeta meta) throws AuthorizationException, KeyAlreadyExistsException {
        return this._blobStore.createBlob(key, meta, null);
    }

    public AtomicOutputStream updateBlob(String key) throws AuthorizationException, KeyNotFoundException {
        return this._blobStore.updateBlob(key, null);
    }

    public ReadableBlobMeta getBlobMeta(String key) throws AuthorizationException, KeyNotFoundException {
        return this._blobStore.getBlobMeta(key, null);
    }

    public void setBlobMetaToExtend(String key, SettableBlobMeta meta) throws AuthorizationException, KeyNotFoundException {
        this._blobStore.setBlobMeta(key, meta, null);
    }

    public void deleteBlob(String key) throws AuthorizationException, KeyNotFoundException {
        this._blobStore.deleteBlob(key, null);
    }

    public InputStreamWithMeta getBlob(String key) throws AuthorizationException, KeyNotFoundException {
        return this._blobStore.getBlob(key, null);
    }

    public Iterator<String> listKeys() {
        return this._blobStore.listKeys();
    }

    public int getBlobReplication(String key) throws AuthorizationException, KeyNotFoundException {
        return this._blobStore.getBlobReplication(key, null);
    }

    public int updateBlobReplication(String key, int replication) throws AuthorizationException, KeyNotFoundException {
        return this._blobStore.updateBlobReplication(key, replication, null);
    }

    public boolean setClient(Map conf, NimbusClient client) {
        return true;
    }

    public void createStateInZookeeper(String key) {
    }

    public void shutdown() {
    }
}

