/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.blobstore;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.storm.blobstore.BlobStoreFile;
import org.apache.storm.hdfs.blobstore.HdfsBlobStoreFile;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsBlobStoreImpl {
    private static final Logger LOG = LoggerFactory.getLogger(HdfsBlobStoreImpl.class);
    private static final long FULL_CLEANUP_FREQ = 3600000L;
    private static final int BUCKETS = 1024;
    private static final Timer timer = new Timer("HdfsBlobStore cleanup thread", true);
    private static final String BLOBSTORE_DATA = "data";
    private Path _fullPath;
    private FileSystem _fs;
    private TimerTask _cleanup = null;
    private Configuration _hadoopConf;
    public static final FsPermission BLOBSTORE_DIR_PERMISSION = FsPermission.createImmutable((short)448);

    public HdfsBlobStoreImpl(Path path, Map<String, Object> conf) throws IOException {
        this(path, conf, new Configuration());
    }

    public HdfsBlobStoreImpl(Path path, Map<String, Object> conf, Configuration hconf) throws IOException {
        FsPermission perms;
        boolean success;
        LOG.info("Blob store based in {}", (Object)path);
        this._fullPath = path;
        this._hadoopConf = hconf;
        this._fs = path.getFileSystem(this._hadoopConf);
        if (!this._fs.exists(this._fullPath) && !(success = this._fs.mkdirs(this._fullPath, perms = new FsPermission(BLOBSTORE_DIR_PERMISSION)))) {
            throw new IOException("Error creating blobstore directory: " + this._fullPath);
        }
        Object shouldCleanup = conf.get("blobstore.cleanup.enable");
        if (Utils.getBoolean((Object)shouldCleanup, (boolean)false)) {
            LOG.debug("Starting hdfs blobstore cleaner");
            this._cleanup = new TimerTask(){

                @Override
                public void run() {
                    try {
                        HdfsBlobStoreImpl.this.fullCleanup(3600000L);
                    }
                    catch (IOException e) {
                        LOG.error("Error trying to cleanup", (Throwable)e);
                    }
                }
            };
            timer.scheduleAtFixedRate(this._cleanup, 0L, 3600000L);
        }
    }

    public Iterator<String> listKeys() throws IOException {
        return new KeyInHashDirIterator();
    }

    public BlobStoreFile read(String key) throws IOException {
        return new HdfsBlobStoreFile(this.getKeyDir(key), BLOBSTORE_DATA, this._hadoopConf);
    }

    public BlobStoreFile write(String key, boolean create) throws IOException {
        return new HdfsBlobStoreFile(this.getKeyDir(key), true, create, this._hadoopConf);
    }

    public boolean exists(String key) {
        Path dir = this.getKeyDir(key);
        boolean res = false;
        try {
            this._fs = dir.getFileSystem(this._hadoopConf);
            res = this._fs.exists(dir);
        }
        catch (IOException e) {
            LOG.warn("Exception checking for exists on: " + key);
        }
        return res;
    }

    public void deleteKey(String key) throws IOException {
        Path keyDir = this.getKeyDir(key);
        HdfsBlobStoreFile pf = new HdfsBlobStoreFile(keyDir, BLOBSTORE_DATA, this._hadoopConf);
        pf.delete();
        this.delete(keyDir);
    }

    protected Path getKeyDir(String key) {
        String hash = String.valueOf(Math.abs((long)key.hashCode()) % 1024L);
        Path hashDir = new Path(this._fullPath, hash);
        Path ret = new Path(hashDir, key);
        LOG.debug("{} Looking for {} in {}", new Object[]{this._fullPath, key, hash});
        return ret;
    }

    public void fullCleanup(long age) throws IOException {
        long cleanUpIfBefore = System.currentTimeMillis() - age;
        KeyInHashDirIterator keys = new KeyInHashDirIterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Path keyDir = this.getKeyDir(key);
            Iterator<BlobStoreFile> i = this.listBlobStoreFiles(keyDir);
            if (!i.hasNext()) {
                try {
                    this._fs.delete(keyDir, true);
                }
                catch (Exception e) {
                    LOG.warn("Could not delete " + keyDir + " will try again later");
                }
            }
            while (i.hasNext()) {
                BlobStoreFile f = i.next();
                if (!f.isTmp() || f.getModTime() > cleanUpIfBefore) continue;
                f.delete();
            }
        }
    }

    protected Iterator<BlobStoreFile> listBlobStoreFiles(Path path) throws IOException {
        ArrayList<HdfsBlobStoreFile> ret = new ArrayList<HdfsBlobStoreFile>();
        FileStatus[] files = this._fs.listStatus(new Path[]{path});
        if (files != null) {
            for (FileStatus sub : files) {
                try {
                    ret.add(new HdfsBlobStoreFile(sub.getPath().getParent(), sub.getPath().getName(), this._hadoopConf));
                }
                catch (IllegalArgumentException e) {
                    LOG.warn("Found an unexpected file in {} {}", (Object)path, (Object)sub.getPath().getName());
                }
            }
        }
        return ret.iterator();
    }

    protected Iterator<String> listKeys(Path path) throws IOException {
        ArrayList<String> ret = new ArrayList<String>();
        FileStatus[] files = this._fs.listStatus(new Path[]{path});
        if (files != null) {
            for (FileStatus sub : files) {
                try {
                    ret.add(sub.getPath().getName().toString());
                }
                catch (IllegalArgumentException e) {
                    LOG.debug("Found an unexpected file in {} {}", (Object)path, (Object)sub.getPath().getName());
                }
            }
        }
        return ret.iterator();
    }

    protected int getBlobReplication(String key) throws IOException {
        Path path = this.getKeyDir(key);
        Path dest = new Path(path, BLOBSTORE_DATA);
        return this._fs.getFileStatus(dest).getReplication();
    }

    protected int updateBlobReplication(String key, int replication) throws IOException {
        Path path = this.getKeyDir(key);
        Path dest = new Path(path, BLOBSTORE_DATA);
        this._fs.setReplication(dest, (short)replication);
        return this._fs.getFileStatus(dest).getReplication();
    }

    protected void delete(Path path) throws IOException {
        this._fs.delete(path, true);
    }

    public void shutdown() {
        if (this._cleanup != null) {
            this._cleanup.cancel();
            this._cleanup = null;
        }
    }

    public class KeyInHashDirIterator
    implements Iterator<String> {
        private int currentBucket = 0;
        private Iterator<String> it = null;
        private String next = null;

        public KeyInHashDirIterator() throws IOException {
            this.primeNext();
        }

        private void primeNext() throws IOException {
            while (this.it == null && this.currentBucket < 1024) {
                String name = String.valueOf(this.currentBucket);
                Path dir = new Path(HdfsBlobStoreImpl.this._fullPath, name);
                try {
                    this.it = HdfsBlobStoreImpl.this.listKeys(dir);
                }
                catch (FileNotFoundException e) {
                    this.it = null;
                }
                if (this.it == null || !this.it.hasNext()) {
                    this.it = null;
                    ++this.currentBucket;
                    continue;
                }
                this.next = this.it.next();
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String current = this.next;
            this.next = null;
            if (this.it != null) {
                if (!this.it.hasNext()) {
                    this.it = null;
                    ++this.currentBucket;
                    try {
                        this.primeNext();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    this.next = this.it.next();
                }
            }
            return current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Delete Not Supported");
        }
    }
}

