/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout;

import java.util.Arrays;
import java.util.List;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.storm.kafka.spout.Func;
import org.apache.storm.kafka.spout.KafkaTuple;
import org.apache.storm.kafka.spout.RecordTranslator;
import org.apache.storm.tuple.Fields;

public class SimpleRecordTranslator<K, V>
implements RecordTranslator<K, V> {
    private static final long serialVersionUID = 4678369144122009596L;
    private final Fields fields;
    private final Func<ConsumerRecord<K, V>, List<Object>> func;
    private final String stream;

    public SimpleRecordTranslator(Func<ConsumerRecord<K, V>, List<Object>> func, Fields fields) {
        this(func, fields, "default");
    }

    public SimpleRecordTranslator(Func<ConsumerRecord<K, V>, List<Object>> func, Fields fields, String stream) {
        this.func = func;
        this.fields = fields;
        this.stream = stream;
    }

    @Override
    public List<Object> apply(ConsumerRecord<K, V> record) {
        KafkaTuple ret = new KafkaTuple();
        ret.addAll(this.func.apply(record));
        return ret.routedTo(this.stream);
    }

    @Override
    public Fields getFieldsFor(String stream) {
        return this.fields;
    }

    @Override
    public List<String> streams() {
        return Arrays.asList(this.stream);
    }
}

