/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.storm.kafka.spout.TopicFilter;

public class PatternTopicFilter
implements TopicFilter {
    private final Pattern pattern;
    private final Set<String> topics = new HashSet<String>();

    public PatternTopicFilter(Pattern pattern) {
        this.pattern = pattern;
    }

    @Override
    public List<TopicPartition> getFilteredTopicPartitions(KafkaConsumer<?, ?> consumer) {
        this.topics.clear();
        ArrayList<TopicPartition> allPartitions = new ArrayList<TopicPartition>();
        for (Map.Entry entry : consumer.listTopics().entrySet()) {
            if (!this.pattern.matcher((CharSequence)entry.getKey()).matches()) continue;
            for (PartitionInfo partitionInfo : (List)entry.getValue()) {
                allPartitions.add(new TopicPartition(partitionInfo.topic(), partitionInfo.partition()));
                this.topics.add(partitionInfo.topic());
            }
        }
        return allPartitions;
    }

    @Override
    public String getTopicsString() {
        return StringUtils.join(this.topics, (String)",");
    }

    public String getTopicsPattern() {
        return this.pattern.pattern();
    }
}

