/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.storm.annotation.InterfaceStability;
import org.apache.storm.kafka.spout.DefaultRecordTranslator;
import org.apache.storm.kafka.spout.EmptyKafkaTupleListener;
import org.apache.storm.kafka.spout.Func;
import org.apache.storm.kafka.spout.KafkaSpoutRetryExponentialBackoff;
import org.apache.storm.kafka.spout.KafkaSpoutRetryService;
import org.apache.storm.kafka.spout.KafkaTupleListener;
import org.apache.storm.kafka.spout.ManualPartitionSubscription;
import org.apache.storm.kafka.spout.NamedTopicFilter;
import org.apache.storm.kafka.spout.PatternTopicFilter;
import org.apache.storm.kafka.spout.RecordTranslator;
import org.apache.storm.kafka.spout.RoundRobinManualPartitioner;
import org.apache.storm.kafka.spout.SerializableDeserializer;
import org.apache.storm.kafka.spout.SimpleRecordTranslator;
import org.apache.storm.kafka.spout.Subscription;
import org.apache.storm.tuple.Fields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaSpoutConfig<K, V>
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaSpoutConfig.class);
    private static final long serialVersionUID = 141902646130682494L;
    public static final long DEFAULT_POLL_TIMEOUT_MS = 200L;
    public static final long DEFAULT_OFFSET_COMMIT_PERIOD_MS = 30000L;
    public static final int DEFAULT_MAX_RETRIES = Integer.MAX_VALUE;
    public static final int DEFAULT_MAX_UNCOMMITTED_OFFSETS = 10000000;
    public static final long DEFAULT_PARTITION_REFRESH_PERIOD_MS = 2000L;
    public static final FirstPollOffsetStrategy DEFAULT_FIRST_POLL_OFFSET_STRATEGY = FirstPollOffsetStrategy.UNCOMMITTED_EARLIEST;
    public static final KafkaSpoutRetryService DEFAULT_RETRY_SERVICE = new KafkaSpoutRetryExponentialBackoff(KafkaSpoutRetryExponentialBackoff.TimeInterval.seconds(0L), KafkaSpoutRetryExponentialBackoff.TimeInterval.milliSeconds(2L), Integer.MAX_VALUE, KafkaSpoutRetryExponentialBackoff.TimeInterval.seconds(10L));
    public static final ProcessingGuarantee DEFAULT_PROCESSING_GUARANTEE = ProcessingGuarantee.AT_LEAST_ONCE;
    public static final KafkaTupleListener DEFAULT_TUPLE_LISTENER = new EmptyKafkaTupleListener();
    public static final int DEFAULT_METRICS_TIME_BUCKET_SIZE_SECONDS = 60;
    private final Map<String, Object> kafkaProps;
    private final Subscription subscription;
    private final long pollTimeoutMs;
    private final RecordTranslator<K, V> translator;
    private final long offsetCommitPeriodMs;
    private final int maxUncommittedOffsets;
    private final FirstPollOffsetStrategy firstPollOffsetStrategy;
    private final KafkaSpoutRetryService retryService;
    private final KafkaTupleListener tupleListener;
    private final long partitionRefreshPeriodMs;
    private final boolean emitNullTuples;
    private final SerializableDeserializer<K> keyDes;
    private final Class<? extends Deserializer<K>> keyDesClazz;
    private final SerializableDeserializer<V> valueDes;
    private final Class<? extends Deserializer<V>> valueDesClazz;
    private final ProcessingGuarantee processingGuarantee;
    private final boolean tupleTrackingEnforced;
    private final int metricsTimeBucketSizeInSecs;

    public KafkaSpoutConfig(Builder<K, V> builder) {
        KafkaSpoutConfig.setKafkaPropsForProcessingGuarantee(builder);
        this.kafkaProps = ((Builder)builder).kafkaProps;
        this.subscription = ((Builder)builder).subscription;
        this.translator = ((Builder)builder).translator;
        this.pollTimeoutMs = ((Builder)builder).pollTimeoutMs;
        this.offsetCommitPeriodMs = ((Builder)builder).offsetCommitPeriodMs;
        this.firstPollOffsetStrategy = ((Builder)builder).firstPollOffsetStrategy;
        this.maxUncommittedOffsets = ((Builder)builder).maxUncommittedOffsets;
        this.retryService = ((Builder)builder).retryService;
        this.tupleListener = ((Builder)builder).tupleListener;
        this.partitionRefreshPeriodMs = ((Builder)builder).partitionRefreshPeriodMs;
        this.emitNullTuples = ((Builder)builder).emitNullTuples;
        this.keyDes = ((Builder)builder).keyDes;
        this.keyDesClazz = ((Builder)builder).keyDesClazz;
        this.valueDes = ((Builder)builder).valueDes;
        this.valueDesClazz = ((Builder)builder).valueDesClazz;
        this.processingGuarantee = ((Builder)builder).processingGuarantee;
        this.tupleTrackingEnforced = ((Builder)builder).tupleTrackingEnforced;
        this.metricsTimeBucketSizeInSecs = ((Builder)builder).metricsTimeBucketSizeInSecs;
    }

    public static Builder<String, String> builder(String bootstrapServers, String ... topics) {
        return KafkaSpoutConfig.setStringDeserializers(new Builder<String, String>(bootstrapServers, StringDeserializer.class, StringDeserializer.class, topics));
    }

    public static Builder<String, String> builder(String bootstrapServers, Collection<String> topics) {
        return KafkaSpoutConfig.setStringDeserializers(new Builder<String, String>(bootstrapServers, StringDeserializer.class, StringDeserializer.class, topics));
    }

    public static Builder<String, String> builder(String bootstrapServers, Pattern topics) {
        return KafkaSpoutConfig.setStringDeserializers(new Builder<String, String>(bootstrapServers, StringDeserializer.class, StringDeserializer.class, topics));
    }

    private static Builder<String, String> setStringDeserializers(Builder<String, String> builder) {
        builder.setProp("key.deserializer", StringDeserializer.class);
        builder.setProp("value.deserializer", StringDeserializer.class);
        return builder;
    }

    private static void setKafkaPropsForProcessingGuarantee(Builder<?, ?> builder) {
        if (((Builder)builder).kafkaProps.containsKey("enable.auto.commit")) {
            LOG.warn("The KafkaConsumer enable.auto.commit setting is not supported. You can configure similar behavior through KafkaSpoutConfig.Builder.setProcessingGuarantee.This will be treated as an error in the next major release.");
            boolean enableAutoCommit = Boolean.parseBoolean(((Builder)builder).kafkaProps.get("enable.auto.commit").toString());
            if (enableAutoCommit) {
                ((Builder)builder).processingGuarantee = ProcessingGuarantee.NO_GUARANTEE;
            } else {
                ((Builder)builder).processingGuarantee = ProcessingGuarantee.AT_LEAST_ONCE;
            }
        }
        String autoOffsetResetPolicy = (String)((Builder)builder).kafkaProps.get("auto.offset.reset");
        if (((Builder)builder).processingGuarantee == ProcessingGuarantee.AT_LEAST_ONCE) {
            if (autoOffsetResetPolicy == null) {
                LOG.info("Setting Kafka consumer property '{}' to 'earliest' to ensure at-least-once processing", (Object)"auto.offset.reset");
                ((Builder)builder).kafkaProps.put("auto.offset.reset", "earliest");
            } else if (!autoOffsetResetPolicy.equals("earliest") && !autoOffsetResetPolicy.equals("none")) {
                LOG.warn("Cannot guarantee at-least-once processing with auto.offset.reset.policy other than 'earliest' or 'none'. Some messages may be skipped.");
            }
        } else if (((Builder)builder).processingGuarantee == ProcessingGuarantee.AT_MOST_ONCE && autoOffsetResetPolicy != null && !autoOffsetResetPolicy.equals("latest") && !autoOffsetResetPolicy.equals("none")) {
            LOG.warn("Cannot guarantee at-most-once processing with auto.offset.reset.policy other than 'latest' or 'none'. Some messages may be processed more than once.");
        }
        LOG.info("Setting Kafka consumer property '{}' to 'false', because the spout does not support auto-commit", (Object)"enable.auto.commit");
        ((Builder)builder).kafkaProps.put("enable.auto.commit", false);
    }

    public Map<String, Object> getKafkaProps() {
        return this.kafkaProps;
    }

    @Deprecated
    public Deserializer<K> getKeyDeserializer() {
        if (this.keyDesClazz != null) {
            try {
                return this.keyDesClazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("Could not instantiate key deserializer " + this.keyDesClazz);
            }
        }
        return this.keyDes;
    }

    @Deprecated
    public Deserializer<V> getValueDeserializer() {
        if (this.valueDesClazz != null) {
            try {
                return this.valueDesClazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("Could not instantiate value deserializer " + this.valueDesClazz);
            }
        }
        return this.valueDes;
    }

    public Subscription getSubscription() {
        return this.subscription;
    }

    public RecordTranslator<K, V> getTranslator() {
        return this.translator;
    }

    public long getPollTimeoutMs() {
        return this.pollTimeoutMs;
    }

    public long getOffsetsCommitPeriodMs() {
        return this.offsetCommitPeriodMs;
    }

    @Deprecated
    public boolean isConsumerAutoCommitMode() {
        return this.kafkaProps.get("enable.auto.commit") == null || Boolean.valueOf((String)this.kafkaProps.get("enable.auto.commit")) != false;
    }

    public ProcessingGuarantee getProcessingGuarantee() {
        return this.processingGuarantee;
    }

    public boolean isTupleTrackingEnforced() {
        return this.tupleTrackingEnforced;
    }

    public String getConsumerGroupId() {
        return (String)this.kafkaProps.get("group.id");
    }

    public FirstPollOffsetStrategy getFirstPollOffsetStrategy() {
        return this.firstPollOffsetStrategy;
    }

    public int getMaxUncommittedOffsets() {
        return this.maxUncommittedOffsets;
    }

    public KafkaSpoutRetryService getRetryService() {
        return this.retryService;
    }

    public KafkaTupleListener getTupleListener() {
        return this.tupleListener;
    }

    public long getPartitionRefreshPeriodMs() {
        return this.partitionRefreshPeriodMs;
    }

    public boolean isEmitNullTuples() {
        return this.emitNullTuples;
    }

    public int getMetricsTimeBucketSizeInSecs() {
        return this.metricsTimeBucketSizeInSecs;
    }

    public String toString() {
        return "KafkaSpoutConfig{kafkaProps=" + this.kafkaProps + ", key=" + this.getKeyDeserializer() + ", value=" + this.getValueDeserializer() + ", pollTimeoutMs=" + this.pollTimeoutMs + ", offsetCommitPeriodMs=" + this.offsetCommitPeriodMs + ", maxUncommittedOffsets=" + this.maxUncommittedOffsets + ", firstPollOffsetStrategy=" + (Object)((Object)this.firstPollOffsetStrategy) + ", subscription=" + this.subscription + ", translator=" + this.translator + ", retryService=" + this.retryService + ", tupleListener=" + this.tupleListener + ", processingGuarantee=" + (Object)((Object)this.processingGuarantee) + ", metricsTimeBucketSizeInSecs=" + this.metricsTimeBucketSizeInSecs + '}';
    }

    public static class Builder<K, V> {
        private final Map<String, Object> kafkaProps;
        private final Subscription subscription;
        private final SerializableDeserializer<K> keyDes;
        private final Class<? extends Deserializer<K>> keyDesClazz;
        private final SerializableDeserializer<V> valueDes;
        private final Class<? extends Deserializer<V>> valueDesClazz;
        private RecordTranslator<K, V> translator;
        private long pollTimeoutMs = 200L;
        private long offsetCommitPeriodMs = 30000L;
        private FirstPollOffsetStrategy firstPollOffsetStrategy = DEFAULT_FIRST_POLL_OFFSET_STRATEGY;
        private int maxUncommittedOffsets = 10000000;
        private KafkaSpoutRetryService retryService = DEFAULT_RETRY_SERVICE;
        private KafkaTupleListener tupleListener = DEFAULT_TUPLE_LISTENER;
        private long partitionRefreshPeriodMs = 2000L;
        private boolean emitNullTuples = false;
        private ProcessingGuarantee processingGuarantee = DEFAULT_PROCESSING_GUARANTEE;
        private boolean tupleTrackingEnforced = false;
        private int metricsTimeBucketSizeInSecs = 60;

        public Builder(String bootstrapServers, String ... topics) {
            this(bootstrapServers, (SerializableDeserializer)null, (SerializableDeserializer)null, (Subscription)new ManualPartitionSubscription(new RoundRobinManualPartitioner(), new NamedTopicFilter(topics)));
        }

        public Builder(String bootstrapServers, Collection<String> topics) {
            this(bootstrapServers, (SerializableDeserializer)null, (SerializableDeserializer)null, (Subscription)new ManualPartitionSubscription(new RoundRobinManualPartitioner(), new NamedTopicFilter(new HashSet<String>(topics))));
        }

        public Builder(String bootstrapServers, Pattern topics) {
            this(bootstrapServers, (SerializableDeserializer)null, (SerializableDeserializer)null, (Subscription)new ManualPartitionSubscription(new RoundRobinManualPartitioner(), new PatternTopicFilter(topics)));
        }

        @Deprecated
        public Builder(String bootstrapServers, SerializableDeserializer<K> keyDes, SerializableDeserializer<V> valDes, String ... topics) {
            this(bootstrapServers, keyDes, valDes, (Subscription)new ManualPartitionSubscription(new RoundRobinManualPartitioner(), new NamedTopicFilter(topics)));
        }

        @Deprecated
        public Builder(String bootstrapServers, SerializableDeserializer<K> keyDes, SerializableDeserializer<V> valDes, Collection<String> topics) {
            this(bootstrapServers, keyDes, valDes, (Subscription)new ManualPartitionSubscription(new RoundRobinManualPartitioner(), new NamedTopicFilter(new HashSet<String>(topics))));
        }

        @Deprecated
        public Builder(String bootstrapServers, SerializableDeserializer<K> keyDes, SerializableDeserializer<V> valDes, Pattern topics) {
            this(bootstrapServers, keyDes, valDes, (Subscription)new ManualPartitionSubscription(new RoundRobinManualPartitioner(), new PatternTopicFilter(topics)));
        }

        @Deprecated
        public Builder(String bootstrapServers, SerializableDeserializer<K> keyDes, SerializableDeserializer<V> valDes, Subscription subscription) {
            this(bootstrapServers, keyDes, null, valDes, null, subscription);
        }

        @Deprecated
        public Builder(String bootstrapServers, Class<? extends Deserializer<K>> keyDes, Class<? extends Deserializer<V>> valDes, String ... topics) {
            this(bootstrapServers, keyDes, valDes, (Subscription)new ManualPartitionSubscription(new RoundRobinManualPartitioner(), new NamedTopicFilter(topics)));
        }

        @Deprecated
        public Builder(String bootstrapServers, Class<? extends Deserializer<K>> keyDes, Class<? extends Deserializer<V>> valDes, Collection<String> topics) {
            this(bootstrapServers, keyDes, valDes, (Subscription)new ManualPartitionSubscription(new RoundRobinManualPartitioner(), new NamedTopicFilter(new HashSet<String>(topics))));
        }

        @Deprecated
        public Builder(String bootstrapServers, Class<? extends Deserializer<K>> keyDes, Class<? extends Deserializer<V>> valDes, Pattern topics) {
            this(bootstrapServers, keyDes, valDes, (Subscription)new ManualPartitionSubscription(new RoundRobinManualPartitioner(), new PatternTopicFilter(topics)));
        }

        @Deprecated
        public Builder(String bootstrapServers, Class<? extends Deserializer<K>> keyDes, Class<? extends Deserializer<V>> valDes, Subscription subscription) {
            this(bootstrapServers, null, keyDes, null, valDes, subscription);
        }

        public Builder(String bootstrapServers, Subscription subscription) {
            this(bootstrapServers, null, null, null, null, subscription);
        }

        private Builder(String bootstrapServers, SerializableDeserializer<K> keyDes, Class<? extends Deserializer<K>> keyDesClazz, SerializableDeserializer<V> valDes, Class<? extends Deserializer<V>> valDesClazz, Subscription subscription) {
            this(keyDes, keyDesClazz, valDes, valDesClazz, subscription, new DefaultRecordTranslator(), new HashMap<String, Object>());
            if (bootstrapServers == null || bootstrapServers.isEmpty()) {
                throw new IllegalArgumentException("bootstrap servers cannot be null");
            }
            this.kafkaProps.put("bootstrap.servers", bootstrapServers);
            super.setNonNullSerDeKafkaProp(keyDes, keyDesClazz, this.valueDes, this.valueDesClazz);
        }

        private Builder(Builder<?, ?> builder, SerializableDeserializer<K> keyDes, Class<? extends Deserializer<K>> keyDesClazz, SerializableDeserializer<V> valueDes, Class<? extends Deserializer<V>> valueDesClazz) {
            this(keyDes, keyDesClazz, valueDes, valueDesClazz, builder.subscription, builder.translator, new HashMap<String, Object>(builder.kafkaProps));
            this.pollTimeoutMs = builder.pollTimeoutMs;
            this.offsetCommitPeriodMs = builder.offsetCommitPeriodMs;
            this.firstPollOffsetStrategy = builder.firstPollOffsetStrategy;
            this.maxUncommittedOffsets = builder.maxUncommittedOffsets;
            this.retryService = builder.retryService;
            super.setNonNullSerDeKafkaProp(keyDes, keyDesClazz, valueDes, valueDesClazz);
        }

        private Builder(SerializableDeserializer<K> keyDes, Class<? extends Deserializer<K>> keyDesClazz, SerializableDeserializer<V> valueDes, Class<? extends Deserializer<V>> valueDesClazz, Subscription subscription, RecordTranslator<K, V> translator, Map<String, Object> kafkaProps) {
            this.keyDes = keyDes;
            this.keyDesClazz = keyDesClazz;
            this.valueDes = valueDes;
            this.valueDesClazz = valueDesClazz;
            this.subscription = subscription;
            this.translator = translator;
            this.kafkaProps = kafkaProps;
        }

        private void setNonNullSerDeKafkaProp(SerializableDeserializer<K> keyDes, Class<? extends Deserializer<K>> keyDesClazz, SerializableDeserializer<V> valueDes, Class<? extends Deserializer<V>> valueDesClazz) {
            if (keyDesClazz != null) {
                this.kafkaProps.put("key.deserializer", keyDesClazz);
            }
            if (keyDes != null) {
                this.kafkaProps.put("key.deserializer", keyDes.getClass());
            }
            if (valueDesClazz != null) {
                this.kafkaProps.put("value.deserializer", valueDesClazz);
            }
            if (valueDes != null) {
                this.kafkaProps.put("value.deserializer", valueDes.getClass());
            }
        }

        @Deprecated
        public <NK> Builder<NK, V> setKey(SerializableDeserializer<NK> keyDeserializer) {
            return new Builder<NK, V>(this, keyDeserializer, null, null, null);
        }

        @Deprecated
        public <NK> Builder<NK, V> setKey(Class<? extends Deserializer<NK>> clazz) {
            return new Builder<K, V>(this, null, clazz, null, null);
        }

        @Deprecated
        public <NV> Builder<K, NV> setValue(SerializableDeserializer<NV> valueDeserializer) {
            return new Builder<K, NV>(this, null, null, valueDeserializer, null);
        }

        @Deprecated
        public <NV> Builder<K, NV> setValue(Class<? extends Deserializer<NV>> clazz) {
            return new Builder<K, V>(this, null, null, null, clazz);
        }

        public Builder<K, V> setProp(String key, Object value) {
            this.kafkaProps.put(key, value);
            return this;
        }

        public Builder<K, V> setProp(Map<String, Object> props) {
            this.kafkaProps.putAll(props);
            return this;
        }

        public Builder<K, V> setProp(Properties props) {
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                if (entry.getKey() instanceof String) {
                    this.kafkaProps.put((String)entry.getKey(), entry.getValue());
                    continue;
                }
                throw new IllegalArgumentException("Kafka Consumer property keys must be Strings");
            }
            return this;
        }

        @Deprecated
        public Builder<K, V> setGroupId(String id) {
            return this.setProp("group.id", id);
        }

        @Deprecated
        public Builder<K, V> setBootstrapServers(String servers) {
            return this.setProp("bootstrap.servers", servers);
        }

        @Deprecated
        public Builder<K, V> setFetchMinBytes(int bytes) {
            return this.setProp("fetch.min.bytes", bytes);
        }

        @Deprecated
        public Builder<K, V> setMaxPartitionFectchBytes(int bytes) {
            return this.setProp("max.partition.fetch.bytes", bytes);
        }

        @Deprecated
        public Builder<K, V> setMaxPollRecords(int records) {
            return this.setProp("max.poll.records", records);
        }

        @Deprecated
        public Builder<K, V> setSSLKeystore(String location, String password) {
            return this.setProp("ssl.keystore.location", location).setProp("ssl.keystore.password", password);
        }

        @Deprecated
        public Builder<K, V> setSSLKeystore(String location, String password, String keyPassword) {
            return this.setProp("ssl.key.password", keyPassword).setSSLKeystore(location, password);
        }

        @Deprecated
        public Builder<K, V> setSSLTruststore(String location, String password) {
            return this.setSecurityProtocol("SSL").setProp("ssl.truststore.location", location).setProp("ssl.truststore.password", password);
        }

        @Deprecated
        public Builder<K, V> setSecurityProtocol(String protocol) {
            return this.setProp("security.protocol", protocol);
        }

        public Builder<K, V> setPollTimeoutMs(long pollTimeoutMs) {
            this.pollTimeoutMs = pollTimeoutMs;
            return this;
        }

        public Builder<K, V> setOffsetCommitPeriodMs(long offsetCommitPeriodMs) {
            this.offsetCommitPeriodMs = offsetCommitPeriodMs;
            return this;
        }

        public Builder<K, V> setMaxUncommittedOffsets(int maxUncommittedOffsets) {
            this.maxUncommittedOffsets = maxUncommittedOffsets;
            return this;
        }

        public Builder<K, V> setFirstPollOffsetStrategy(FirstPollOffsetStrategy firstPollOffsetStrategy) {
            this.firstPollOffsetStrategy = firstPollOffsetStrategy;
            return this;
        }

        public Builder<K, V> setRetry(KafkaSpoutRetryService retryService) {
            if (retryService == null) {
                throw new NullPointerException("retryService cannot be null");
            }
            this.retryService = retryService;
            return this;
        }

        public Builder<K, V> setTupleListener(KafkaTupleListener tupleListener) {
            if (tupleListener == null) {
                throw new NullPointerException("KafkaTupleListener cannot be null");
            }
            this.tupleListener = tupleListener;
            return this;
        }

        public Builder<K, V> setRecordTranslator(RecordTranslator<K, V> translator) {
            this.translator = translator;
            return this;
        }

        public Builder<K, V> setRecordTranslator(Func<ConsumerRecord<K, V>, List<Object>> func, Fields fields) {
            return this.setRecordTranslator(new SimpleRecordTranslator<K, V>(func, fields));
        }

        public Builder<K, V> setRecordTranslator(Func<ConsumerRecord<K, V>, List<Object>> func, Fields fields, String stream) {
            return this.setRecordTranslator(new SimpleRecordTranslator<K, V>(func, fields, stream));
        }

        public Builder<K, V> setPartitionRefreshPeriodMs(long partitionRefreshPeriodMs) {
            this.partitionRefreshPeriodMs = partitionRefreshPeriodMs;
            return this;
        }

        public Builder<K, V> setEmitNullTuples(boolean emitNullTuples) {
            this.emitNullTuples = emitNullTuples;
            return this;
        }

        public Builder<K, V> setProcessingGuarantee(ProcessingGuarantee processingGuarantee) {
            this.processingGuarantee = processingGuarantee;
            return this;
        }

        public Builder<K, V> setTupleTrackingEnforced(boolean tupleTrackingEnforced) {
            this.tupleTrackingEnforced = tupleTrackingEnforced;
            return this;
        }

        public Builder<K, V> setMetricsTimeBucketSizeInSecs(int metricsTimeBucketSizeInSecs) {
            this.metricsTimeBucketSizeInSecs = metricsTimeBucketSizeInSecs;
            return this;
        }

        public KafkaSpoutConfig<K, V> build() {
            return new KafkaSpoutConfig(this);
        }
    }

    @InterfaceStability.Unstable
    public static enum ProcessingGuarantee {
        AT_LEAST_ONCE,
        AT_MOST_ONCE,
        NO_GUARANTEE;

    }

    public static enum FirstPollOffsetStrategy {
        EARLIEST,
        LATEST,
        UNCOMMITTED_EARLIEST,
        UNCOMMITTED_LATEST;


        public String toString() {
            return "FirstPollOffsetStrategy{" + super.toString() + "}";
        }
    }
}

