/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.eventhubs.trident;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.eventhubs.spout.EventData;
import org.apache.storm.eventhubs.spout.EventHubReceiverImpl;
import org.apache.storm.eventhubs.spout.EventHubSpoutConfig;
import org.apache.storm.eventhubs.spout.IEventHubReceiver;
import org.apache.storm.eventhubs.spout.IEventHubReceiverFactory;
import org.apache.storm.eventhubs.trident.ITridentPartitionManager;
import org.apache.storm.eventhubs.trident.ITridentPartitionManagerFactory;
import org.apache.storm.eventhubs.trident.Partition;
import org.apache.storm.eventhubs.trident.Partitions;
import org.apache.storm.eventhubs.trident.TridentPartitionManager;
import org.apache.storm.trident.operation.TridentCollector;
import org.apache.storm.trident.spout.IPartitionedTridentSpout;
import org.apache.storm.trident.topology.TransactionAttempt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionalTridentEventHubEmitter
implements IPartitionedTridentSpout.Emitter<Partitions, Partition, Map> {
    private static final Logger logger = LoggerFactory.getLogger(TransactionalTridentEventHubEmitter.class);
    private final int batchSize;
    private final EventHubSpoutConfig spoutConfig;
    private Map<String, ITridentPartitionManager> pmMap;
    private ITridentPartitionManagerFactory pmFactory;
    private IEventHubReceiverFactory recvFactory;

    public TransactionalTridentEventHubEmitter(EventHubSpoutConfig spoutConfig) {
        this(spoutConfig, spoutConfig.getReceiverCredits(), null, null);
    }

    public TransactionalTridentEventHubEmitter(final EventHubSpoutConfig spoutConfig, int batchSize, ITridentPartitionManagerFactory pmFactory, IEventHubReceiverFactory recvFactory) {
        this.spoutConfig = spoutConfig;
        this.batchSize = batchSize;
        this.pmFactory = pmFactory;
        this.recvFactory = recvFactory;
        this.pmMap = new HashMap<String, ITridentPartitionManager>();
        if (this.pmFactory == null) {
            this.pmFactory = new ITridentPartitionManagerFactory(){

                @Override
                public ITridentPartitionManager create(IEventHubReceiver receiver) {
                    return new TridentPartitionManager(spoutConfig, receiver);
                }
            };
        }
        if (this.recvFactory == null) {
            this.recvFactory = new IEventHubReceiverFactory(){

                @Override
                public IEventHubReceiver create(EventHubSpoutConfig config, String partitionId) {
                    return new EventHubReceiverImpl(config, partitionId);
                }
            };
        }
    }

    public void close() {
        for (ITridentPartitionManager pm : this.pmMap.values()) {
            pm.close();
        }
    }

    private ITridentPartitionManager getOrCreatePartitionManager(Partition partition) {
        ITridentPartitionManager pm;
        if (!this.pmMap.containsKey(partition.getId())) {
            IEventHubReceiver receiver = this.recvFactory.create(this.spoutConfig, partition.getId());
            pm = this.pmFactory.create(receiver);
            this.pmMap.put(partition.getId(), pm);
        } else {
            pm = this.pmMap.get(partition.getId());
        }
        return pm;
    }

    public void emitPartitionBatch(TransactionAttempt attempt, TridentCollector collector, Partition partition, Map meta) {
        String offset = (String)meta.get("offset");
        int count = Integer.parseInt((String)meta.get("count"));
        logger.info("re-emit for partition " + partition.getId() + ", offset=" + offset + ", count=" + count);
        ITridentPartitionManager pm = this.getOrCreatePartitionManager(partition);
        List<EventData> listEvents = pm.receiveBatch(offset, count);
        if (listEvents.size() != count) {
            logger.error("failed to refetch eventhub messages, new count=" + listEvents.size());
            return;
        }
        for (EventData ed : listEvents) {
            List<Object> tuples = this.spoutConfig.getEventDataScheme().deserialize(ed.getMessage());
            collector.emit(tuples);
        }
    }

    public Map emitPartitionBatchNew(TransactionAttempt attempt, TridentCollector collector, Partition partition, Map meta) {
        ITridentPartitionManager pm = this.getOrCreatePartitionManager(partition);
        String offset = "-1";
        if (meta != null && meta.containsKey("nextOffset")) {
            offset = (String)meta.get("nextOffset");
        }
        String nextOffset = offset;
        List<EventData> listEvents = pm.receiveBatch(offset, this.batchSize);
        for (EventData ed : listEvents) {
            nextOffset = ed.getMessageId().getOffset();
            List<Object> tuples = this.spoutConfig.getEventDataScheme().deserialize(ed.getMessage());
            collector.emit(tuples);
        }
        HashMap<String, String> newMeta = new HashMap<String, String>();
        newMeta.put("offset", offset);
        newMeta.put("nextOffset", nextOffset);
        newMeta.put("count", "" + listEvents.size());
        return newMeta;
    }

    public List<Partition> getOrderedPartitions(Partitions partitions) {
        return partitions.getPartitions();
    }

    public void refreshPartitions(List<Partition> partitionList) {
    }
}

