/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.eventhubs.trident;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.storm.eventhubs.spout.EventHubSpoutConfig;
import org.apache.storm.eventhubs.spout.IEventHubReceiverFactory;
import org.apache.storm.eventhubs.trident.ITridentPartitionManagerFactory;
import org.apache.storm.eventhubs.trident.Partition;
import org.apache.storm.eventhubs.trident.Partitions;
import org.apache.storm.eventhubs.trident.TransactionalTridentEventHubEmitter;
import org.apache.storm.trident.operation.TridentCollector;
import org.apache.storm.trident.spout.IOpaquePartitionedTridentSpout;
import org.apache.storm.trident.topology.TransactionAttempt;

public class OpaqueTridentEventHubEmitter
implements IOpaquePartitionedTridentSpout.Emitter<Partitions, Partition, Map> {
    private final TransactionalTridentEventHubEmitter transactionalEmitter;

    public OpaqueTridentEventHubEmitter(EventHubSpoutConfig spoutConfig) {
        this.transactionalEmitter = new TransactionalTridentEventHubEmitter(spoutConfig);
    }

    public OpaqueTridentEventHubEmitter(EventHubSpoutConfig spoutConfig, int batchSize, ITridentPartitionManagerFactory pmFactory, IEventHubReceiverFactory recvFactory) {
        this.transactionalEmitter = new TransactionalTridentEventHubEmitter(spoutConfig, batchSize, pmFactory, recvFactory);
    }

    public void close() {
        this.transactionalEmitter.close();
    }

    public Map emitPartitionBatch(TransactionAttempt attempt, TridentCollector collector, Partition partition, Map meta) {
        return this.transactionalEmitter.emitPartitionBatchNew(attempt, collector, partition, meta);
    }

    public List<Partition> getOrderedPartitions(Partitions partitions) {
        return this.transactionalEmitter.getOrderedPartitions(partitions);
    }

    public List<Partition> getPartitionsForTask(int taskId, int numTasks, Partitions allPartitionInfo) {
        List<Partition> orderedPartitions = this.getOrderedPartitions(allPartitionInfo);
        ArrayList<Partition> taskPartitions = new ArrayList<Partition>(orderedPartitions == null ? 0 : orderedPartitions.size());
        if (orderedPartitions != null) {
            for (int i = taskId; i < orderedPartitions.size(); i += numTasks) {
                taskPartitions.add(orderedPartitions.get(i));
            }
        }
        return taskPartitions;
    }

    public void refreshPartitions(List<Partition> partitionList) {
        this.transactionalEmitter.refreshPartitions(partitionList);
    }
}

