/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.eventhubs.spout;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.amqp_1_0.client.Message;
import org.apache.storm.eventhubs.spout.EventData;
import org.apache.storm.eventhubs.spout.EventHubReceiverImpl;
import org.apache.storm.eventhubs.spout.EventHubSpoutConfig;
import org.apache.storm.eventhubs.spout.IEventDataScheme;
import org.apache.storm.eventhubs.spout.IEventHubReceiver;
import org.apache.storm.eventhubs.spout.IEventHubReceiverFactory;
import org.apache.storm.eventhubs.spout.IPartitionCoordinator;
import org.apache.storm.eventhubs.spout.IPartitionManager;
import org.apache.storm.eventhubs.spout.IPartitionManagerFactory;
import org.apache.storm.eventhubs.spout.IStateStore;
import org.apache.storm.eventhubs.spout.MessageId;
import org.apache.storm.eventhubs.spout.PartitionManager;
import org.apache.storm.eventhubs.spout.StaticPartitionCoordinator;
import org.apache.storm.eventhubs.spout.ZookeeperStateStore;
import org.apache.storm.metric.api.IMetric;
import org.apache.storm.spout.SpoutOutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.base.BaseRichSpout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventHubSpout
extends BaseRichSpout {
    private static final Logger logger = LoggerFactory.getLogger(EventHubSpout.class);
    private final UUID instanceId;
    private final EventHubSpoutConfig eventHubConfig;
    private final IEventDataScheme scheme;
    private final int checkpointIntervalInSeconds;
    private IStateStore stateStore;
    private IPartitionCoordinator partitionCoordinator;
    private IPartitionManagerFactory pmFactory;
    private IEventHubReceiverFactory recvFactory;
    private SpoutOutputCollector collector;
    private long lastCheckpointTime;
    private int currentPartitionIndex = -1;

    public EventHubSpout(String username, String password, String namespace, String entityPath, int partitionCount) {
        this(new EventHubSpoutConfig(username, password, namespace, entityPath, partitionCount));
    }

    public EventHubSpout(EventHubSpoutConfig spoutConfig) {
        this(spoutConfig, null, null, null);
    }

    public EventHubSpout(EventHubSpoutConfig spoutConfig, IStateStore store, IPartitionManagerFactory pmFactory, IEventHubReceiverFactory recvFactory) {
        this.eventHubConfig = spoutConfig;
        this.scheme = spoutConfig.getEventDataScheme();
        this.instanceId = UUID.randomUUID();
        this.checkpointIntervalInSeconds = spoutConfig.getCheckpointIntervalInSeconds();
        this.lastCheckpointTime = System.currentTimeMillis();
        this.stateStore = store;
        this.pmFactory = pmFactory;
        if (this.pmFactory == null) {
            this.pmFactory = new IPartitionManagerFactory(){

                @Override
                public IPartitionManager create(EventHubSpoutConfig spoutConfig, String partitionId, IStateStore stateStore, IEventHubReceiver receiver) {
                    return new PartitionManager(spoutConfig, partitionId, stateStore, receiver);
                }
            };
        }
        this.recvFactory = recvFactory;
        if (this.recvFactory == null) {
            this.recvFactory = new IEventHubReceiverFactory(){

                @Override
                public IEventHubReceiver create(EventHubSpoutConfig spoutConfig, String partitionId) {
                    return new EventHubReceiverImpl(spoutConfig, partitionId);
                }
            };
        }
    }

    public void preparePartitions(Map config, int totalTasks, int taskIndex, SpoutOutputCollector collector) throws Exception {
        this.collector = collector;
        if (this.stateStore == null) {
            String zkEndpointAddress = this.eventHubConfig.getZkConnectionString();
            if (zkEndpointAddress == null || zkEndpointAddress.length() == 0) {
                List zkServers = (List)config.get("storm.zookeeper.servers");
                Integer zkPort = ((Number)config.get("storm.zookeeper.port")).intValue();
                StringBuilder sb = new StringBuilder();
                for (String zk : zkServers) {
                    if (sb.length() > 0) {
                        sb.append(',');
                    }
                    sb.append(zk + ":" + zkPort);
                }
                zkEndpointAddress = sb.toString();
            }
            this.stateStore = new ZookeeperStateStore(zkEndpointAddress, Integer.parseInt(config.get("storm.zookeeper.retry.times").toString()), Integer.parseInt(config.get("storm.zookeeper.retry.interval").toString()));
        }
        this.stateStore.open();
        this.partitionCoordinator = new StaticPartitionCoordinator(this.eventHubConfig, taskIndex, totalTasks, this.stateStore, this.pmFactory, this.recvFactory);
        for (IPartitionManager partitionManager : this.partitionCoordinator.getMyPartitionManagers()) {
            partitionManager.open();
        }
    }

    public void open(Map config, TopologyContext context, SpoutOutputCollector collector) {
        logger.info("begin: open()");
        String topologyName = (String)config.get("topology.name");
        this.eventHubConfig.setTopologyName(topologyName);
        int totalTasks = context.getComponentTasks(context.getThisComponentId()).size();
        int taskIndex = context.getThisTaskIndex();
        if (totalTasks > this.eventHubConfig.getPartitionCount()) {
            throw new RuntimeException("total tasks of EventHubSpout is greater than partition count.");
        }
        logger.info(String.format("topologyName: %s, totalTasks: %d, taskIndex: %d", topologyName, totalTasks, taskIndex));
        try {
            this.preparePartitions(config, totalTasks, taskIndex, collector);
        }
        catch (Exception e) {
            collector.reportError((Throwable)e);
            throw new RuntimeException(e);
        }
        context.registerMetric("EventHubReceiver", new IMetric(){

            public Object getValueAndReset() {
                HashMap concatMetricsDataMaps = new HashMap();
                for (IPartitionManager partitionManager : EventHubSpout.this.partitionCoordinator.getMyPartitionManagers()) {
                    concatMetricsDataMaps.putAll(partitionManager.getMetricsData());
                }
                return concatMetricsDataMaps;
            }
        }, Integer.parseInt(config.get("topology.builtin.metrics.bucket.size.secs").toString()));
        logger.info("end open()");
    }

    public void nextTuple() {
        EventData eventData = null;
        List<IPartitionManager> partitionManagers = this.partitionCoordinator.getMyPartitionManagers();
        for (int i = 0; i < partitionManagers.size(); ++i) {
            this.currentPartitionIndex = (this.currentPartitionIndex + 1) % partitionManagers.size();
            IPartitionManager partitionManager = partitionManagers.get(this.currentPartitionIndex);
            if (partitionManager == null) {
                throw new RuntimeException("partitionManager doesn't exist.");
            }
            eventData = partitionManager.receive();
            if (eventData != null) break;
        }
        if (eventData != null) {
            MessageId messageId = eventData.getMessageId();
            Message message = eventData.getMessage();
            List<Object> tuples = this.scheme.deserialize(message);
            if (tuples != null) {
                this.collector.emit(tuples, (Object)messageId);
            }
        }
        this.checkpointIfNeeded();
    }

    public void ack(Object msgId) {
        MessageId messageId = (MessageId)msgId;
        IPartitionManager partitionManager = this.partitionCoordinator.getPartitionManager(messageId.getPartitionId());
        String offset = messageId.getOffset();
        partitionManager.ack(offset);
    }

    public void fail(Object msgId) {
        MessageId messageId = (MessageId)msgId;
        IPartitionManager partitionManager = this.partitionCoordinator.getPartitionManager(messageId.getPartitionId());
        String offset = messageId.getOffset();
        partitionManager.fail(offset);
    }

    public void deactivate() {
        this.checkpoint();
    }

    public void close() {
        for (IPartitionManager partitionManager : this.partitionCoordinator.getMyPartitionManagers()) {
            partitionManager.close();
        }
        this.stateStore.close();
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        declarer.declare(this.scheme.getOutputFields());
    }

    private void checkpointIfNeeded() {
        long nextCheckpointTime = this.lastCheckpointTime + (long)(this.checkpointIntervalInSeconds * 1000);
        if (nextCheckpointTime < System.currentTimeMillis()) {
            this.checkpoint();
            this.lastCheckpointTime = System.currentTimeMillis();
        }
    }

    private void checkpoint() {
        for (IPartitionManager partitionManager : this.partitionCoordinator.getMyPartitionManagers()) {
            partitionManager.checkpoint();
        }
    }
}

