/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.eventhubs.spout;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.qpid.amqp_1_0.client.Message;
import org.apache.qpid.amqp_1_0.type.Section;
import org.apache.qpid.amqp_1_0.type.messaging.AmqpValue;
import org.apache.qpid.amqp_1_0.type.messaging.ApplicationProperties;
import org.apache.qpid.amqp_1_0.type.messaging.Data;
import org.apache.storm.eventhubs.spout.IEventDataScheme;
import org.apache.storm.tuple.Fields;

public class EventDataScheme
implements IEventDataScheme {
    private static final long serialVersionUID = 1L;

    @Override
    public List<Object> deserialize(Message message) {
        ArrayList<Object> fieldContents = new ArrayList<Object>();
        Map metaDataMap = new HashMap();
        String messageData = "";
        for (Section section : message.getPayload()) {
            if (section instanceof Data) {
                Data data = (Data)section;
                messageData = new String(data.getValue().getArray());
                continue;
            }
            if (section instanceof AmqpValue) {
                AmqpValue amqpValue = (AmqpValue)section;
                messageData = amqpValue.getValue().toString();
                continue;
            }
            if (!(section instanceof ApplicationProperties)) continue;
            ApplicationProperties applicationProperties = (ApplicationProperties)section;
            metaDataMap = applicationProperties.getValue();
        }
        fieldContents.add(messageData);
        fieldContents.add(metaDataMap);
        return fieldContents;
    }

    @Override
    public Fields getOutputFields() {
        return new Fields(new String[]{"message", "metadata"});
    }
}

