/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.eventhubs.samples.bolt;

import java.util.List;
import java.util.Map;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.BasicOutputCollector;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.base.BaseBasicBolt;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.tuple.Values;
import org.apache.storm.utils.TupleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartialCountBolt
extends BaseBasicBolt {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(PartialCountBolt.class);
    private static final int PartialCountBatchSize = 1000;
    private int partialCount;

    public void prepare(Map stormConf, TopologyContext context) {
        this.partialCount = 0;
    }

    public void execute(Tuple tuple, BasicOutputCollector collector) {
        if (TupleUtils.isTick((Tuple)tuple)) {
            return;
        }
        ++this.partialCount;
        if (this.partialCount == 1000) {
            collector.emit((List)new Values(new Object[]{1000}));
            this.partialCount = 0;
        }
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        declarer.declare(new Fields(new String[]{"partial_count"}));
    }
}

