/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.eventhubs.samples.bolt;

import java.util.HashMap;
import java.util.Map;
import org.apache.storm.metric.api.IMetric;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.BasicOutputCollector;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.base.BaseBasicBolt;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.utils.TupleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalCountBolt
extends BaseBasicBolt {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(GlobalCountBolt.class);
    private long globalCount;
    private long globalCountDiff;
    private long lastMetricsTime;
    private long throughput;

    public void prepare(Map config, TopologyContext context) {
        this.globalCount = 0L;
        this.globalCountDiff = 0L;
        this.lastMetricsTime = System.nanoTime();
        context.registerMetric("GlobalMessageCount", new IMetric(){

            public Object getValueAndReset() {
                long now = System.nanoTime();
                long millis = (now - GlobalCountBolt.this.lastMetricsTime) / 1000000L;
                GlobalCountBolt.this.throughput = GlobalCountBolt.this.globalCountDiff / millis * 1000L;
                HashMap<String, Long> values = new HashMap<String, Long>();
                values.put("global_count", GlobalCountBolt.this.globalCount);
                values.put("throughput", GlobalCountBolt.this.throughput);
                GlobalCountBolt.this.lastMetricsTime = now;
                GlobalCountBolt.this.globalCountDiff = 0L;
                return values;
            }
        }, ((Integer)config.get("topology.builtin.metrics.bucket.size.secs")).intValue());
    }

    public void execute(Tuple tuple, BasicOutputCollector collector) {
        if (TupleUtils.isTick((Tuple)tuple)) {
            return;
        }
        int partial = (Integer)tuple.getValueByField("partial_count");
        this.globalCount += (long)partial;
        this.globalCountDiff += (long)partial;
        if (this.globalCountDiff == (long)partial && this.globalCount != this.globalCountDiff) {
            logger.info("Current throughput (messages/second): " + this.throughput);
        }
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
    }
}

